<?php

namespace IZON\Admin\DI;

use DI\Definition\Source\DefinitionSource;

use DI\Definition\Source\MutableDefinitionSource;

use DI\FactoryInterface;
use DI\Proxy\ProxyFactory;

use IZON\Admin\DI\Definition\Resolver\ResolverDispatcher;

use IZON\DI\Container;
use Psr\Container\ContainerInterface;

/**
 * Container pro pristup k modulum
 *
 * upravena trida z DI\Container
 *
 */
class ModulesAwareContainer extends Container implements ContainerInterface, FactoryInterface
{
    /**
     * Use the ContainerBuilder to ease constructing the Container.
     *
     * @see ContainerBuilder
     *
     * @param DefinitionSource   $definitionSource
     * @param ProxyFactory       $proxyFactory
     * @param ContainerInterface $wrapperContainer If the container is wrapped by another container.
     */
    public function __construct(
        ?MutableDefinitionSource $definitionSource = null,
        ?ProxyFactory $proxyFactory = null,
        ?ContainerInterface $wrapperContainer = null
    ) {
        parent::__construct($definitionSource, $proxyFactory, $wrapperContainer);

        $this->definitionResolver = new ResolverDispatcher($this->delegateContainer, $proxyFactory);
    }
}
