<?php

namespace IZON\Admin\DI\Definition\Resolver;

use DI\Definition\Definition;
use DI\Definition\Resolver\DefinitionResolver;

use IZON\Admin\Config;

use IZON\Admin\DI\Definition\ModuleConfigDefinition;
use IZON\Admin\Domain\AdminModuleSetting;

use IZON\Admin\Services\AdminService;

use Psr\Container\ContainerInterface;

/**
 *
 */
class ModuleConfigsResolver implements DefinitionResolver
{
    private ContainerInterface $container;

    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }

    /**
     * Resolve an array definition to a value
     *
     * @param ModuleConfigDefinition $definition
     *
     * {@inheritdoc}
     */
    public function resolve(Definition $definition, array $parameters = [])
    {
        $adminService = $this->container->get(Config::ADMIN_SERVICE_IDENTIFIER);
        /** @var AdminService $adminService*/
        $settings = $adminService->getModuleSettings($definition->getModuleIdentifier());

        $settingsArray = [];
        foreach ($settings as $setting) {
            /** @var AdminModuleSetting $setting */
            $settingsArray[$setting->getParamIdentifier()] = $setting->getValue();
        }
        return $settingsArray;
    }

    /**
     * {@inheritdoc}
     */
    public function isResolvable(Definition $definition, array $parameters = []): bool
    {
        return true;
    }
}
