<?php

namespace IZON\Admin\DI\Definition;

use DI\Definition\Definition;

use DI\Scope;

/**
 * definice pro ziskani vsech konfiguraci modulu
 */
class ModuleConfigsDefinition implements Definition
{
    /**
     * Entry name
     * @var string
     */
    private $name;
    
    protected $moduleIdentifier;
    
    
    public function __construct($name, $moduleIdentifier)
    {
        $this->name = $name;
        $this->moduleIdentifier = $moduleIdentifier;
    }

    
    /**
     * @return string Entry name
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * {@inheritdoc}
     */
    public function getScope()
    {
        return Scope::SINGLETON;
    }

    public function getModuleIdentifier()
    {
        return $this->moduleIdentifier;
    }
}
