<?php

namespace IZON\Admin\DI\Definition\Helper;

use DI\Definition\ArrayDefinitionExtension;
use DI\Definition\Helper\DefinitionHelper;
use IZON\Admin\DI\Definition\ModuleConfigsDefinition;

/**
 * Helps load module configuration
 */
class ModuleConfigsDefinitionHelper implements DefinitionHelper
{
    /**
     *
     * @var string identifikator modulu pod kterym se nachazi
     */
    protected $moduleIdentifier;

    /**
     * @param string $moduleIdentifier identifikator modulu
     */
    public function __construct($moduleIdentifier)
    {
        $this->moduleIdentifier = $moduleIdentifier;
    }

    /**
     * @param string $entryName Container entry name
     *
     * @return ArrayDefinitionExtension
     */
    public function getDefinition($entryName)
    {
        return new ModuleConfigsDefinition(
            $entryName,
            $this->moduleIdentifier
        );
    }
}
