<?php

namespace IZON\Admin\DI\Definition\Helper;

use DI\Definition\Definition;
use DI\Definition\Helper\DefinitionHelper;

use IZON\Admin\DI\Definition\ModuleConfigDefinition;

/**
 * Helps load module configuration
 */
class ModuleConfigDefinitionHelper implements DefinitionHelper
{
    /**
     *
     * @var string identifikator modulu pod kterym se nachazi
     */
    protected string $moduleIdentifier;

    /**
     *
     * @var string indentifikator parametru pod kterym se hodnota parametru nachazi
     */
    protected string $paramIdentifier;

    /**
     * @param array $moduleIdentifier Values to add to the array.
     */
    public function __construct($moduleIdentifier, $paramIdentifier)
    {
        $this->moduleIdentifier = $moduleIdentifier;
        $this->paramIdentifier = $paramIdentifier;
    }

    /**
     * @param string $entryName Container entry name
     */
    public function getDefinition(string $entryName): Definition
    {
        return new ModuleConfigDefinition(
            $entryName,
            $this->moduleIdentifier,
            $this->paramIdentifier
        );
    }
}
