<?php

namespace IZON\Admin\DB;

use IZON\DB\QueryFactory;
use IZON\DB\QueryHelpers;

/**
 *
 */
class AdminModuleQueryFactory implements QueryFactory
{
    /**
     * Vraci vsechny aktivni moduly
     * @param QueryHelpers $queryHelpers
     */
    public function findActiveModules_0(QueryHelpers $queryHelpers)
    {
        return 'select ' . $queryHelpers->getClassProperties("m")
                . ' from ' . $queryHelpers->getTableName("m")
                . ' where ' . $queryHelpers->getCoumnName("enabled") . ' = 1 '
                . ' order by ' . $queryHelpers->getCoumnName("moduleOrder") . " asc limit :maxResults offset :firstResult";
    }
    
    /**
     * Vraci vsechny viditelne moduly v adminu
     * @param QueryHelpers $queryHelpers
     */
    public function findAdminVisibleModules_0(QueryHelpers $queryHelpers)
    {
        return 'select ' . $queryHelpers->getClassProperties("m")
                . ' from ' . $queryHelpers->getTableName("m")
                . ' where ' . $queryHelpers->getCoumnName("enabled") . ' = 1 '
                    . ' and ' . $queryHelpers->getCoumnName("adminVisible") . ' = 1 '
                . ' order by ' . $queryHelpers->getCoumnName("moduleOrder") . " asc limit :maxResults offset :firstResult";
    }
    
    public function findUserAdminVisibleModules_1(QueryHelpers $queryHelpers)
    {
        $query = 'select ' . $queryHelpers->getClassProperties("m")
                . ' from ' . $queryHelpers->getTableName("m")
                    . ' join admin_group_modules agm on ' . $queryHelpers->getCoumnName("id", "m") . " = agm.module_id "
                    . ' join admin_user_groups aug on agm.group_id = aug.group_id '
                . ' where ' . $queryHelpers->getCoumnName("enabled") . ' = 1 '
                    . ' and ' . $queryHelpers->getCoumnName("adminVisible") . ' = 1 '
                    . ' and aug.user_id = :arg0 '
                . ' order by ' . $queryHelpers->getCoumnName("moduleOrder") . " asc limit :maxResults offset :firstResult";
        //        var_dump($query);
        return $query;
    }
}
