<?php

namespace IZON\Admin\Config;

use IZON\Admin\Config;
use IZON\Admin\Dao\AdminModuleDao;
use IZON\Admin\Dao\AdminModuleSettingDao;
use IZON\Admin\Dao\AdminUserDao;
use IZON\Admin\Services\Impl\AdminServiceImpl;
use IZON\Admin\Services\Impl\SessionServiceImpl;
use IZON\Admin\Web\Controllers\DashboardController;
use IZON\Admin\Web\Controllers\LoginController;
use IZON\Admin\Web\Controllers\LogoutController;
use IZON\Admin\Web\Controllers\NotificationsController;
use IZON\Admin\Web\Interceptors\LoadAdminVersionInterceptor;
use IZON\Admin\Web\Interceptors\LoadedModulesInterceptor;
use IZON\Admin\Web\Interceptors\LoggedUserCheckInterceptor;
use IZON\Admin\Web\Interceptors\LoggedUserInterceptor;
use IZON\DB\DaoFactoryBean;
use Psr\Container\ContainerInterface;
use function IZON\DI\factory;
use function IZON\DI\get;
use function IZON\DI\object;


return [
    'izon.admin.dao.adminModuleDao' => factory(function(ContainerInterface $container) {
        $bean = new DaoFactoryBean(
            $container->get(Config::DEFAULT_DB_CONNECTION_IDENTIFIER),
            AdminModuleDao::class
        );
        return $bean->getObject();
    }),

    'izon.admin.dao.adminModuleSettingDao' => factory(function(ContainerInterface $container) {
        $bean = new DaoFactoryBean(
            $container->get(Config::DEFAULT_DB_CONNECTION_IDENTIFIER),
            AdminModuleSettingDao::class
        );
        return $bean->getObject();
    }),

    'izon.admin.dao.adminUserDao' => factory(function(ContainerInterface $container) {
        $bean = new DaoFactoryBean(
            $container->get(Config::DEFAULT_DB_CONNECTION_IDENTIFIER),
            AdminUserDao::class
        );
        return $bean->getObject();
    }),

    Config::ADMIN_SERVICE_IDENTIFIER => object(AdminServiceImpl::class)
        ->constructor(
            get('izon.admin.service.adminSessionService'),
            get('izon.admin.dao.adminModuleDao'),
            get('izon.admin.dao.adminModuleSettingDao')
        ),

    // TODO: umoznit jeho prepsani v configu
    'izon.admin.service.adminSessionService' => object(SessionServiceImpl::class)
        ->constructor(
            get('izon.admin.dao.adminUserDao')
        ),

    //// controllery pro admin
    // controller pro prihlaseni a odhlaseni
    Config::LOGIN_CONTROLLER_IDENTIFIER => object(LoginController::class)
        ->constructor(get('izon.admin.service.adminSessionService')),

    // controller pro uvodku adminu
    Config::DASHBOARD_CONTROLLER_IDENTIFIER => object(DashboardController::class)
        ->constructor(get(Config::ADMIN_SERVICE_IDENTIFIER)),

    // controller pro odhlaseni z admina
    Config::LOGOUT_CONTROLLER_IDENTIFIER => object(LogoutController::class)
        ->constructor(get('izon.admin.service.adminSessionService')),

    //// interceptory pro admin
    // interceptor pro kontrolu prihlaseneho uzivatele
    Config::LOGGED_USER_CHECK_INTERCEPTOR_IDENTIFIER => object(LoggedUserCheckInterceptor::class)
        ->constructor(get('izon.admin.service.adminSessionService')),

    // interceptor pro nacteni prihlaseneho uzivatele
    Config::LOGGED_USER_INTERCEPTOR_IDENTIFIER => object(LoggedUserInterceptor::class)
        ->constructor(get('izon.admin.service.adminSessionService')),

    // interceptor pro nacteni akci admina
    Config::MODULES_ACTIONS_INTERCEPTOR_IDENTIFIER => object(LoadedModulesInterceptor::class)
        ->constructor(
            get(Config::ADMIN_SERVICE_IDENTIFIER),
            get('admin.modulesActions')
        ),

    // nacte verzi admina
    Config::LOAD_ADMIN_VERSION_INTERCEPTOR_IDENTIFIER => object(LoadAdminVersionInterceptor::class)
        ->constructor(get(Config::ADMIN_SERVICE_IDENTIFIER)),

    // controller pro spravu notifikaci
    Config::NOTIFICATIONS_CONTROLLER_IDENTIFIER => object(NotificationsController::class)
        ->constructor(get(Config::ADMIN_SERVICE_IDENTIFIER)),
];
