<?php

namespace IZON\Modules\AdminUsers\Admin\Forms;

use IZON\Forms\Form;

/**
 * factory pro vytvareni formularu pro uzivatel
 */
class AdminUserFormFactory {


    public static function createUserForm(array $activeCountries, array $activeLocales, array $roles) {
        $form = new Form();

        $form->addIdField("id", _("Id"));
        $form->addCharField("firstName", _("Jméno"));
        $form->addCharField("lastName", _("Příjmení"));
        $form->addCharField("login", _("Login"));
        $form->addPasswordField("password", _("Nové heslo"));
        $form->addCheckboxField("active", _("Aktivní"));
        $form->addCheckboxField("superuser", _("Superuser"));

        $form->addSelectField("country", __("Země"))
            ->setOptions($activeCountries, function($country) { return ['key' => $country->getId(), 'label' => $country->getName()]; });
        $form->addSelectField("interfaceLocale", __("Locale rozhraní"))
            ->setOptions($activeLocales, function($locale) { return ['key' => $locale->getId(), 'label' => $locale->getLocaleTag()]; });

        $form->addCheckboxListField('roles', __('Role'))
            ->setOptions($roles, function($role) { return ['key' => $role->getId(), 'label' => $role->getName()]; });

        return $form;
    }

    public static function createUserRoleForm($preffix, $tagName) {
        $form = new Form($preffix);
        $form->addCheckboxField("hasRole", $tagName)->setUseLabel(false);

        return $form;
    }

    public static function createRoleForm() {
        $form = new Form();
        $form->addIdField("id", _("Id"));
        $form->addCharField("name", _("Název"));
        $form->addTextField("description", _("Popis"));

        return $form;
    }
}
