<?php

namespace IZON\Modules\AdminUsers\Admin\Controllers;

use IZON\Admin\Web\Controllers\AbstractBaseController;
use IZON\DB\Paginator\PaginatorConfig;
use IZON\DB\Paginator\PaginatorConfigInterface;
use IZON\Forms\Form;
use IZON\Forms\FormInterface;
use IZON\Modules\AdminUsers\Admin\Forms\AdminUserFormFactory;
use IZON\Modules\AdminUsers\Admin\Services\AdminUserService;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * @extends AbstractBaseController<AdminUserService>
 */
class AdminUserController extends AbstractBaseController {

    protected AdminUserService $userService;

    protected int $maxPageSize = 1000;


    public function __construct(AdminUserService $userService, $viewName) {
        parent::__construct($userService, $viewName);
        $this->userService = $userService;
        $this->viewName = $viewName;
    }

    /**
     * execute je defaultni akce, ktera se zavola, pokud neni specifikovana jina metoda
     * @param HttpRequest $request
     * @return ModelAndView
     */
    public function execute(HttpRequest $request) {
        $modelAndView = new ModelAndView("admin/" . $this->viewName . "/list");

        $paginatorConfig = $this->userService->getPaginatorConfig($this->maxPageSize);

        $modelAndView->putParameter("paginatorConfig", $paginatorConfig);

        $modelAndView->putParameter("pageContent", $this->userService->getPage($paginatorConfig));

        return $modelAndView;
    }

    /**
     * zobrazi editacni formular a naplni ho daty
     */
    public function edit(HttpRequest $request) {
        $modelAndView = new ModelAndView("admin/" . $this->viewName . "/form");

        $form = $this->createForm();
        $modelAndView->putParameter("form", $form);

        if($request->hasParameter("id")) { // posila se id, musi se editovat odpovidajici objekt
            $id = $request->getParameter("id");

            $object = $this->userService->get($id);
            $form->edit($object);
        } else {
            $article = $this->createDomainObject();
            $form->edit($article);
        }

        return $modelAndView;
    }

    public function save(HttpRequest $request) {
        $form = $this->createForm();
        $form->setValues($request->getParameters());

        if( $request->hasParameter("id")
            && $request->getParameter("id") != '' ) { // posila se id, musi se editovat odpovidajici objekt
            $id = $request->getParameter("id");

            $object = $this->userService->get($id);
            $oldPasswordHash = $object->getPassword();

            $form->flush($object);

            if($object->getPassword() != '') { // men heslo jen pokud je vyplnene
                $object->setPassword($this->userService->computePasswordHash($object->getPassword()));
            } else {
                $object->setPassword($oldPasswordHash);
            }

            $this->userService->update($object);
        } else {
            $object = $this->createDomainObject();

            $form->flush($object);

            // vytvor hash vybraneho hesla
            $object->setPassword($this->userService->computePasswordHash($object->getPassword()));

            $this->userService->save($object);
        }

        $modelAndView = ModelAndView::createControllerRedirect(
                                        $request->getCalledControllerId(),
                                        [],
                                        'execute'
                                    );

        return $modelAndView;
    }

    public function delete(HttpRequest $request) {
        if(!$request->hasParameter("id")) {
            throw new \Exception("Can't delete. No id provided");
        }

        $id = $request->getParameter("id");
        $this->userService->delete($id);

        $modelAndView = ModelAndView::createControllerRedirect(
                                        $request->getCalledControllerId(),
                                        [],
                                        'execute'
                                    );

        return $modelAndView;
    }

    protected function createForm() {
        $activeCountries = $this->userService->getActiveCountries();
        $activeLocales = $this->userService->getActiveLocales();
        $roles = $this->userService->getRoles();

        return AdminUserFormFactory::createUserForm($activeCountries, $activeLocales, $roles);
    }

    protected function createRoleForm($preffix, $name) {
        return AdminUserFormFactory::createUserRoleForm($preffix, $name);
    }

    protected function createDomainObject() {
        return $this->userService->createDomainObject();
    }

    protected function getPage(PaginatorConfig $config) {
        // TODO: Implement getPage() method.
    }

    protected function modifyPaginator(PaginatorConfig $paginatorConfig, Form $filterForm) {
        // TODO: Implement modifyPaginator() method.
    }

    protected function getPaginatorSessionIdentifier(): string {
        // TODO: Implement getPaginatorSessionIndentifier() method.
    }

    protected function createPaginatorConfig(): PaginatorConfigInterface {
        // TODO: Implement createPaginatorConfig() method.
    }

    protected function createFilterForm(): FormInterface {
        // TODO: Implement createFilterForm() method.
    }
}
