<?php

// includuje funkce pro konfiguraci DI
use function IZON\DI\get;
use function IZON\DI\object;
use function IZON\DI\factory;
// includuje funkce pro konfiguraci DI
use function IZON\Admin\DI\moduleGet;
use IZON\Admin\Config;
use IZON\DB\TransactionManagementFactory;
use IZON\Modules\AdminUsers\Admin\Services\AdminUserService;
use IZON\Modules\AdminUsers\Admin\Controllers\AdminUserController;
use IZON\Modules\AdminUsers\Admin\Services\AdminRoleService;
use IZON\Modules\AdminUsers\Admin\Controllers\AdminRoleController;

$dbConnIdentifier = Config::DEFAULT_DB_CONNECTION_IDENTIFIER;

return [
    'moduleActions' => [
        // jaka akce se ma provest defaultne pri kliknuti na nazev modulu
        'defaultAction' => 'execute',
        // jake akce modul obsahuje a jak se maji pojmenovat
        'actions' => [
            'execute' => [
                'name' => "Uživatelé",
                'controllerId' => 'admin.userController',
                'action' => 'execute',
            ],
            'execute.roles' => [
                'name' => "Role",
                'controllerId' => 'admin.roleController',
                'action' => 'execute',
            ],
        ],
        // jake akce se maji zobrazit v menu
        'menuActions' => ['execute', 'execute.roles']
    ],

    'admin.userServiceBare' => object(AdminUserService::class)
            ->constructor(
                    get('izon.admin.service.adminSessionService'),
                    get(Config::DEFAULT_DB_ENTITY_MANAGER_IDENTIFIER)
            ),
    'admin.userServiceTMF' => object(TransactionManagementFactory::class)
            ->constructor(get($dbConnIdentifier),
                    moduleGet('admin.userServiceBare')
            ),
    'admin.userService' => factory([\IZON\Admin\DI\moduleIdentifier('admin.userServiceTMF'), 'create']),
    'admin.userController' => object(AdminUserController::class)
            ->constructor(
                    moduleGet('admin.userService'),
                    "izon/admin-users-module/users"
            ),

    'admin.roleServiceBare' => object(AdminRoleService::class)
            ->constructor(
                    get(Config::DEFAULT_DB_ENTITY_MANAGER_IDENTIFIER)
            ),
    'admin.roleServiceTMF' => object(TransactionManagementFactory::class)
            ->constructor(get($dbConnIdentifier),
                    moduleGet('admin.roleServiceBare')
            ),
    'admin.roleService' => factory([\IZON\Admin\DI\moduleIdentifier('admin.roleServiceTMF'), 'create']),
    'admin.roleController' => object(AdminRoleController::class)
            ->constructor(
                    moduleGet('admin.roleService'),
                    "izon/admin-users-module/roles"
            ),
];
