<?php
namespace IZON\Modules\AdminUsers\Admin\Services;

use Doctrine\Common\Persistence\ObjectRepository;
use Doctrine\ORM\Tools\Pagination\Paginator;
use IZON\Admin\Domain\AdminRole;
use IZON\Admin\Domain\AdminUser;
use IZON\Admin\Services\LoggedAdminUserSessionServiceInterface;
use IZON\DB\EntityManagerInterface;
use IZON\DB\Paginator\PageContent;
use IZON\DB\Paginator\PaginatorConfig;
use IZON\DB\Repository\BaseRepository;
use IZON\DBLocale\Domain\DBCountry;
use IZON\DBLocale\Domain\DBLocale;

/**
 * servis pro zpracovani referenci
 */
class AdminUserService {
    
    /**
     * @var LoggedAdminUserSessionServiceInterface
     */
    protected $sessionService;
    
    /**
     * @var EntityManagerInterface
     */
    protected $entityManager;
    
    /**
     * @var BaseRepository
     */
    protected $adminUserRepsitory;
    
    /**
     * @var ObjectRepository 
     */
    protected $adminRoleRepsitory;
    
    /**
     * @var ObjectRepository 
     */
    protected $localeRepsitory;

    /**
     * @var ObjectRepository 
     */
    protected $coutryRepsitory;

    
    function __construct(LoggedAdminUserSessionServiceInterface $sessionService, EntityManagerInterface $entityManager) {
        $this->sessionService = $sessionService;
        $this->entityManager = $entityManager;
        
        $this->adminUserRepsitory = $entityManager->getRepository(AdminUser::class);
        $this->adminRoleRepsitory = $entityManager->getRepository(AdminRole::class);
        $this->localeRepsitory = $entityManager->getRepository(DBLocale::class);
        $this->coutryRepsitory = $entityManager->getRepository(DBCountry::class);
    }


    /**
     * @param $pageSize
     * @return \IZON\DB\Paginator\PaginatorConfigInterface
     */
    public function getPaginatorConfig($pageSize) {
        $paginatorConfig = $this->adminUserRepsitory->createDefaultPaginatorConfig($pageSize);
        return $paginatorConfig;
    }

    /**
     * @param PaginatorConfig $config
     * @return \IZON\DB\Paginator\PageContentInterface
     */
    public function getPage(PaginatorConfig $config) {
        $pageContent = $this->adminUserRepsitory->paginate($config);
        return $pageContent;
    }
    
    /**
     * @param int $id
     * @return AdminUser
     */
    public function get($id) {
        $user = $this->adminUserRepsitory->find($id);
        return $user;
    }
    
    public function update(AdminUser $obj) {
        $this->entityManager->persist($obj);
        $this->entityManager->flush(); // DOTO: nemelo by se takle presunout do factory proxy
    }
    
    public function save(AdminUser $obj) {
        $country = $this->coutryRepsitory->find(1); // DOTO: take from config
        $obj->setCountry($country);
        $locale = $this->localeRepsitory->find(1); // DOTO: take from config
        $obj->setInterfaceLocale($locale);
        $this->entityManager->persist($obj);
        $this->entityManager->flush();
    }

    public function delete($id) {
        /* @var $user AdminUser */
        $user = $this->adminUserRepsitory->find($id);
        $this->entityManager->remove($user);
        $this->entityManager->flush();
    }
    
    
    public function getRoles() {
        return $this->adminRoleRepsitory->findBy([], ["name" => 'ASC']);
    }
    
    public function getRoleById(int $roleId) {
      return $this->adminRoleRepsitory->find($roleId);
    }

    public function getActiveCountries(): array {
        return $this->coutryRepsitory->findBy([], ["name" => 'ASC']);
    }
    
    public function getActiveLocales(): array {
        return $this->localeRepsitory->findBy([], ["localeTag" => 'ASC']);
    }
    
    public function computePasswordHash($password) {
        return $this->sessionService->computePasswordHash($password);
    }
    
    public function createDomainObject() {
        $user = new AdminUser();

        return $user;
    }
    
}