<?php
namespace IZON\Modules\AdminUsers\Admin\Controllers;

use IZON\Admin\Domain\AdminRole;
use IZON\Admin\Web\Controllers\AbstractBaseController;
use IZON\DB\Paginator\PaginatorConfig;
use IZON\DB\Paginator\PaginatorConfigInterface;
use IZON\Forms\Form;
use IZON\Forms\FormInterface;
use IZON\Modules\AdminUsers\Admin\Forms\AdminUserFormFactory;
use IZON\Modules\AdminUsers\Admin\Services\AdminRoleService;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use Exception;


class AdminRoleController extends AbstractBaseController {

    /**
     * @var AdminRoleService
     */
    protected $roleService;

    /**
     *
     * @var string name of view to call
     */
    protected $viewName;

    protected $pageSize = 1000;


    function __construct(AdminRoleService $roleService, $viewName) {
        parent::__construct($roleService);
        $this->roleService = $roleService;
        $this->viewName = $viewName;
    }


    /**
     * execute je defaultni akce, ktera se zavola, pokud neni specifikovana jina metoda
     * @param HttpRequest $request
     * @return ModelAndView
     */
    public function execute(HttpRequest $request) {
        $modelAndView = new ModelAndView("admin/". $this->viewName ."/list");

        $paginatorConfig = $this->roleService->getPaginatorConfig($this->pageSize);

        $modelAndView->putParameter("paginatorConfig", $paginatorConfig);

        $modelAndView->putParameter("pageContent",
            $this->roleService->getPage($paginatorConfig));

        return $modelAndView;
    }

    /**
     * zobrazi editacni formular a naplni ho daty
     */
    public function edit(HttpRequest $request) {
        $modelAndView = new ModelAndView("admin/". $this->viewName ."/form");

        $form = $this->createForm();
        $modelAndView->putParameter("form", $form);

        if( $request->hasParameter("id") ) { // posila se id, musi se editovat odpovidajici objekt
            $id = $request->getParameter("id");

            $object = $this->roleService->get($id);
            $form->edit($object);
        } else {
            $article = $this->createDomainObject();
            $form->edit($article);
        }

        return $modelAndView;
    }

    public function save(HttpRequest $request) {
        $form = $this->createForm();
        $form->setValues($request->getParameters());

        if( $request->hasParameter("id")
            && $request->getParameter("id") != '' ) { // posila se id, musi se editovat odpovidajici objekt
            $id = $request->getParameter("id");

            $object = $this->roleService->get($id);
            $form->flush($object);

            $this->roleService->update($object);
        } else {
            // TODO: potom odstranit
            $object = $this->createDomainObject();
            $form->flush($object);

            $this->roleService->save($object);
        }

        $modelAndView = ModelAndView::createControllerRedirect(
                                        $request->getCalledControllerId(), 
                                        [], 
                                        'execute'
                                    );
        
        return $modelAndView;
    }

    public function delete(HttpRequest $request) {
        if( !$request->hasParameter("id") ) {
            throw new \Exception("Can't delete. No id provided");
        }

        $id = $request->getParameter("id");
        $this->roleService->delete($id);

        $modelAndView = ModelAndView::createControllerRedirect(
                                        $request->getCalledControllerId(), 
                                        [], 
                                        'execute'
                                    );
        
        return $modelAndView;
    }


    protected function createForm() {
        return AdminUserFormFactory::createRoleForm();
    }

    protected function createDomainObject() {
        $user = new AdminRole();

        $user->setId(NULL);

        return $user;
    }

    protected function getPage(PaginatorConfig $config) {
        // TODO: Implement getPage() method.
    }

    protected function modifyPaginator(PaginatorConfig $paginatorConfig, Form $filterForm) {
        // TODO: Implement modifyPaginator() method.
    }

    protected function getPaginatorSessionIdentifier(): string {
        // TODO: Implement getPaginatorSessionIndentifier() method.
    }

    protected function createPaginatorConfig(): PaginatorConfigInterface {
        // TODO: Implement createPaginatorConfig() method.
    }

    protected function createFilterForm(): FormInterface {
        // TODO: Implement createFilterForm() method.
    }
}