<?php

use IZON\DB\Paginator\PaginatorConfig;

// soucasny modul
$thisModule = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
/* @var $paginatorConfig PaginatorConfig */
$paginatorConfig = PHPView\getParameter("paginatorConfig");
/* @var $pageContent IZON\DB\Paginator\PageContent */
$pageContent = \PHPView\getParameter("pageContent");


AdminPHPView\renderModuleTitle();


$editURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "edit", [], $thisModule->getIdentifier());



$totalCount = $pageContent->getTotalCount();
$maxPageSize = $paginatorConfig->getPageSize();
$firstResult = $paginatorConfig->getFirstResult();

$pagesCout = ceil($totalCount / $maxPageSize);
$currentPage = $firstResult / $maxPageSize + 1;


$filterActive = "";
if(PHPView\getParameter("filterActive")) {
    $filterActive = " active";
}
$filterForm = PHPView\getParameter("filterForm");

?>
<div class="col-xs-12" style="padding-top: 10px; padding-bottom: 10px;">
    <a class="btn btn--small btn--mint" href="<?= $editURL ?>"><i class="fas fa-plus"></i><?= __('Přidat') ?></a>
</div>
 

<section class="col-xs-12">
    <div class="table-icons" style="display: none;">
        <i class="fas fa-check" data-fa-symbol="icon--true"></i>
        <i class="fas fa-times" data-fa-symbol="icon--false"></i>
        <i class="fas fa-edit" data-fa-symbol="icon--edit"></i>
        <i class="fas fa-trash-alt" data-fa-symbol="icon--delete"></i>
    </div>
    <table class="table--dynamic">

        <thead>
            <tr>
                <?php
                writeListHeaderField($paginatorConfig, "id", __("#"), '80px');
                writeListHeaderField($paginatorConfig, "login", __("Login"));
                writeListHeaderField($paginatorConfig, "firstName", __("Jméno"));
                writeListHeaderField($paginatorConfig, "lastName", __("Příjmení"));
                writeListHeaderField($paginatorConfig, "superuser", __("Superuser"));
                writeListHeaderField($paginatorConfig, "active", __("Aktivní"));
                ?>
                <th style="width: 10rem">Funkce</th>
            </tr>
        </thead>
        <tbody id="list-table">
            <?php
            foreach($pageContent->getPage() as $obj) {
                /* @var $obj IZON\Admin\Domain\AdminUser */
                $editURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "edit", ["id" => $obj->getId()], $thisModule->getIdentifier());
                $deleteURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "delete", ["id" => $obj->getId()], $thisModule->getIdentifier());
                ?>
                <tr>
                    <td><?= $obj->getId() ?></td>
                    <td><a href="<?= $editURL ?>"><?= $obj->getLogin() ?></a></td>
                    <td><a href="<?= $editURL ?>"><?= $obj->getFirstName() ?></a></td>
                    <td><a href="<?= $editURL ?>"><?= $obj->getLastName() ?></a></td>
                    <td>
                        <?= AdminPHPView\getPropetryCodeToChange($thisModule, $obj, 'superuser') ?>
                    </td>
                    <td>
                        <?= AdminPHPView\getPropetryCodeToChange($thisModule, $obj, 'active') ?>
                    </td>
                    <td>
                        <a href="<?= $editURL ?>" ><svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--edit"></use></svg></a>
                        <a href="<?= $deleteURL ?>" class="js-delete-record" rel="<?= '#'. $obj->getId() . ' ' . $obj->getFirstName() . " " . $obj->getLastName() ?>"><svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--delete"></use></svg></a>
                    </td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>

</section>

<!-- POPUP - Confirmation of deleting item -->
<div class="popup">
    <div class="popup__message confirmation-deleting">
        <div class="close"><i class="fas fa-times"></i></div>
        <span><?= __('Opravdu chcete smazat záznam') ?> <strong class="zaznam"></strong>?</span>
        <a href="#" class="btn btn--gray" id="back" style="margin-right: 3rem;"><i class="fas fa-angle-left"></i><?= __('Vrátit') ?></a>
        <a href="#" class="btn btn--mint" id="do"><i class="fas fa-trash"></i><?= __('Smazat') ?></a>
    </div>
</div>

</div><?php // <div class="col-xs-12 row-controlls">     ?>

<?php

function writeListHeaderField(PaginatorConfig $paginatorConfig, $propertyName, $feldName, $width = NULL) {
    $isSortable = $paginatorConfig->isOrder($propertyName);
    $order = $paginatorConfig->getOrders()[0];

    $classes = [];
    // je raditelny sloupe
    if($isSortable) {
        $classes[] = 'sortable';
        if($order != null && $order->getName() == $propertyName) {
            if($order->getType() == \IZON\DB\QueryParams\OrderBy::ORDER_ASC) {
                $classes[] = "sorted--down";
            } else {
                $classes[] = "sorted--up";
            }
        }
    }
    // sirka sloupecku
    $widthStyle = "";
    if($width != NULL) { // je nastavena nejaka sirka
        if(IZON\String\endsWith($width, "%") // konci procentem
            || IZON\String\endsWith($width, "px")) { // konci pixely
            $widthStyle = "width: " . $width;
        } else {
            throw new Exception("Nepodporovany fomat sirky sloupce. Podporovany jsou % a px");
        }
    }

    echo '<th ' . (!IZON\Arrays\isEmpty($classes) ? 'class="' . implode(" ", $classes) . '"' : '')
        . ' data-property-name="' . $propertyName
        . '" data-order="' . ($order != null && $order->getType() == \IZON\DB\QueryParams\OrderBy::ORDER_ASC ? 'down' : 'up')
        . '" style="' . $widthStyle . '" >
        ' . $feldName;
    echo '<span class="sortable__down"></span>';
    echo '<span class="sortable__up"></span>';
    echo '</th>';
}