<?php
namespace IZON\Modules\AdminUsers\Admin\Services;

use Doctrine\Common\Persistence\ObjectRepository;
use Doctrine\ORM\Tools\Pagination\Paginator;
use IZON\Admin\Domain\AdminRole;
use IZON\Admin\Domain\AdminUser;
use IZON\Admin\Services\AbstractBaseService;
use IZON\DB\EntityManagerInterface;
use IZON\DB\Paginator\PageContent;
use IZON\DB\Paginator\PaginatorConfig;
use IZON\DB\Repository\BaseRepository;

/**
 * servis pro zpracovani referenci
 */
class AdminRoleService extends AbstractBaseService {    

    /**
     * @var EntityManagerInterface
     */
    protected $entityManager;
    
    /**
     * @var BaseRepository
     */
    protected $adminRoleRepsitory;
    

/// generovany konstruktor    
    function __construct(EntityManagerInterface $entityManager) {
        $this->entityManager = $entityManager;
        $this->adminRoleRepsitory = $entityManager->getRepository(AdminRole::class);
    }

    /**
     * @param $pageSize
     * @return \IZON\DB\Paginator\PaginatorConfigInterface
     */
    public function getPaginatorConfig($pageSize) {
        // DOTO: implement pagination in db layer
        $paginatorConfig = $this->adminRoleRepsitory->createDefaultPaginatorConfig($pageSize);
        return $paginatorConfig;
    }
    
    /**
     * vrati aktivni moduly
     */
    public function getPage(PaginatorConfig $config) {
        $pageContent = $this->adminRoleRepsitory->paginate($config);
        return $pageContent;
    }
    
    /**
     * @param integer $id
     * @return AdminUser
     */
    public function get($id) {
        $user = $this->adminRoleRepsitory->find($id);
        return $user;
    }
    
    public function update(AdminRole $obj) {
        $this->entityManager->persist($obj);
        $this->entityManager->flush();
    }
    
    public function save(AdminRole $obj) {
        $this->entityManager->persist($obj);
        $this->entityManager->flush();
    }

    public function delete($id) {
        /* @var $user AdminRole */
        $user = $this->adminRoleRepsitory->find($id);
        $this->entityManager->remove($user);
        $this->entityManager->flush();
    }
}