<?php

use IZON\Admin\Domain\AdminUser;
use \IZON\Admin\Domain\AdminRole;
use IZON\Admin\MVC\ModuleInfo;

use function PHPView\getParameter;
use function IZON\Admin\Forms\getAdminField;
use function AdminPHPView\getModuleActionURL;

$thisModule = getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER);
$form = getParameter("form");

/** @var array<int, AdminRole> $roles */
$roles = getParameter("roles");

/** @var AdminUser $adminLoggedUser */
$adminLoggedUser = getParameter("adminLoggedAdminUser");

$saveURL = getModuleActionURL($thisModule->getControllerId(), "save", [], $thisModule->getIdentifier());

if($form->getField("id")->getValue() == NULL) {
    $pageTitle = __("Nový uživatel");
} else {
    $objectName = trim($form->getField("firstName")->getValue().' '.$form->getField("lastName")->getValue());
    $pageTitle = '<light>'.__('Editace uživatele').':</light> '.trim($objectName);
}

$checkBoxParamsInline = ['caption' => ['attributes' => ['style' => 'margin-right: 1rem;']]];

echo '<div class="col-xs-12">'.
    '<h1>'.$pageTitle.'</h1>'.
    '</div>'.LF;
?>

<form class="container" action="<?= $saveURL ?>" method="post" enctype="multipart/form-data" role="form">
    <div>
        <?php
        echo getAdminField($form, "id");

        echo getAdminField($form, "login");
        echo getAdminField($form, "password");
        echo getAdminField($form, "firstName");
        echo getAdminField($form, "lastName");

        echo getAdminField($form, "active", $checkBoxParamsInline);
        if($adminLoggedUser->getSuperuser()) {
            echo getAdminField($form, "superuser", $checkBoxParamsInline);
        }

        echo '<div style="display: '.($adminLoggedUser->getSuperuser() ? 'block' : 'none').';">';
            echo getAdminField($form, "fkCountryId");
            echo getAdminField($form, "fkLanguageId");
            echo getAdminField($form, "fkInterfaceLocaleId");
        echo '</div>';
        ?>

        <h2 style="margin-bottom: 0;">Role</h2>
        <?php
        $roleForms = getParameter('roleForms');
        foreach($roleForms as $roleId => $roleForm) {
            echo '<div>';
            echo getAdminField($roleForm, "hasRole", $checkBoxParamsInline);
            $description = $roles[$roleId]->getDescription();
            if (trim($description) !== ''){
                echo sprintf('<span style="position: relative;top: -10px;font-style: italic;">- %s</span>', $roles[$roleId]->getDescription());
            }
            echo '</div>';
        }
        ?>
    </div>

    <div class="col-xs-12">
        <div class="form__item--buttons">
            <?php
            $backURL = getModuleActionURL($thisModule->getControllerId(), "execute", [], $thisModule->getIdentifier());
            echo '<a href="'
                .$backURL
                .'" class="btn btn--gray" style="float: left;"><i class="fas fa-angle-left"></i>'
                .__('Zpět')
                .'</a>'
                .
                '<button type="submit" class="btn btn--mint btn--big"><i class="fas fa-check"></i>'
                .__('Uložit')
                .'</button>';
            ?>
        </div>
    </div>
</form>
