<?php

use IZON\Admin\MVC\ModuleInfo;
use IZON\Admin\Domain\AdminModule;
use IZON\Admin\Domain\AdminRole;

use function PHPView\getParameter;
use function AdminPHPView\getModuleActionURL;

$thisModule = getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER);

$editURL = getModuleActionURL($thisModule->getControllerId(), "edit", [], $thisModule->getIdentifier());
?>

<div class="col-xs-12">
    <h1><?= __("Seznam rolí") ?></h1>
</div>

<div class="col-xs-12" style="padding-top: 10px; padding-bottom: 10px;">
    <a class="btn btn--small btn--mint" href="<?= $editURL ?>"><i class="fas fa-plus"></i><?= __('Přidat') ?></a>
</div>

<section class="col-xs-12">
    <div class="table-icons" style="display: none;">
        <i class="fas fa-check" data-fa-symbol="icon--true"></i>
        <i class="fas fa-times" data-fa-symbol="icon--false"></i>
        <i class="fas fa-edit" data-fa-symbol="icon--edit"></i>
        <i class="fas fa-trash-alt" data-fa-symbol="icon--delete"></i>
    </div>

    <table class="table--dynamic">
        <tr>
            <th>#</th>
            <th><?= __("Jméno") ?></th>
            <th><?= __("Popis") ?></th>
            <th><?= __("Moduly") ?></th>
            <th><?= __('Funkce') ?></th>
        </tr>

        <?php
        $pageContent = getParameter("pageContent");

        /** @var AdminRole $role */
        foreach($pageContent->getPage() as $role) {
            $editURL = getModuleActionURL($thisModule->getControllerId(), "edit", ["id" => $role->getId()], $thisModule->getIdentifier());
            $deleteURL = getModuleActionURL($thisModule->getControllerId(), "delete", ["id" => $role->getId()], $thisModule->getIdentifier());

            $modules = array_map(function(AdminModule $am):string {return $am->getName();}, $role->getModules());
            $modules = join(', ', $modules);
            ?>
            <tr>
                <td><?= $role->getId() ?></td>
                <td><a href="<?= $editURL ?>"><?= $role->getName() ?></a></td>
                <td><?= $role->getDescription() ?></td>
                <td><?= $modules ?></td>
                <td>
                    <a href="<?= $editURL ?>" class="fce--edit"><svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--edit"></use></svg></a>
                    <a href="<?= $deleteURL ?>" class="fce--delete" rel="<?= $role->getName() ?>"></a>
                </td>
            </tr>
            <?php
        }
        ?>
    </table>
</section>

<!-- POPUP - Confirmation of deleting item -->
<div class="popup">
    <div class="popup__message confirmation-deleting">
        <div class="close"></div>
        <span><?= __('Opravdu chcete smazat záznam') ?> <strong class="zaznam"></strong>?</span>
        <a href="#" class="btn--secondary" id="back"><?= __('Vrátit') ?></a>
        <a href="#" class="btn--important" id="do"><?= __('Smazat') ?></a>
    </div>
</div>
