<?php

use IZON\Admin\MVC\ModuleInfo;
use IZON\Admin\Domain\AdminModule;

use function AdminPHPView\getModuleActionURL;
use function IZON\Admin\Forms\getAdminField;
use function PHPView\getParameter;

$thisModule = getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER);
$form = getParameter("form");

/** @var array<int, AdminModule> $modules */
$modules = getParameter("modules");

$saveURL = getModuleActionURL($thisModule->getControllerId(), "save", [], $thisModule->getIdentifier());

$checkBoxParamsInline = ['caption' => ['attributes' => ['style' => 'margin-right: 1rem;']]];

if($form->getField("id")->getValue() == NULL) {
    $pageTitle = __("Nová role");
} else {
    $objectName = $form->getField("name")->getValue();
    $pageTitle = '<light>' . __('Editace role') . ':</light> ' . trim($objectName);
}

echo '<div class="col-xs-12">' .
 '<h1>' . $pageTitle . '</h1>' .
 '</div>' . LF;
?>

<form class="container" action="<?= $saveURL ?>" method="post" enctype="multipart/form-data" role="form">
    <div>
        <?php
        echo getAdminField($form, "id");

        echo getAdminField($form, "name");
        echo getAdminField($form, "description");
        ?>
    </div>

    <h2 style="margin-bottom: 0;">Moduly</h2>
    <?php
    $moduleForms = getParameter('moduleForms');
    foreach($moduleForms as $moduleId => $moduleForm) {
        $module = $modules[$moduleId];
        echo '<div style="display: '.($module->getAdminVisible() ? 'inline-block' : 'none').';">';
        echo getAdminField($moduleForm, "hasModule", $checkBoxParamsInline);
        echo '</div>';
    }
    ?>

    <div class="col-xs-12">
        <div class="form__item--buttons">
            <?php
            $backURL = getModuleActionURL($thisModule->getControllerId(), "execute", [], $thisModule->getIdentifier());
            echo '<a href="' . $backURL . '" class="btn btn--gray" style="float: left;"><i class="fas fa-angle-left"></i>' . __('Zpět') . '</a>' .
            '<button type="submit" class="btn btn--mint btn--big"><i class="fas fa-check"></i>' . __('Uložit') . '</button>';
            ?>
        </div>
    </div>
</form>
