<?php

namespace IZON\Modules\AdminUsers\Admin\Services;

use IZON\Admin\Dao\AdminModuleDao;
use IZON\Admin\Dao\AdminRoleDao;
use IZON\Admin\Dao\AdminRoleModuleDao;
use IZON\Admin\Dao\AdminUserRoleDao;
use IZON\Admin\Domain\AdminModule;
use IZON\Admin\Domain\AdminRole;
use IZON\Admin\Domain\AdminRoleModule;
use IZON\Admin\Services\AbstractBaseService;
use IZON\DB\OrderBy;
use IZON\DB\Paginator\PaginatorConfig;

/**
 * servis pro zpracovani referenci
 */
class RoleService extends AbstractBaseService
{
    /**
     * @var AdminRoleDao
     */
    protected $adminRoleDao;

    /**
     * @var AdminUserRoleDao
     */
    protected $adminUserRoleDao;

    /**
     * @var AdminRoleModuleDao
     */
    protected $adminRoleModuleDao;

    /**
     * @var AdminModuleDao
     */
    protected $adminModuleDao;


    /// generovany konstruktor
    public function __construct(AdminRoleDao $adminRoleDao, AdminUserRoleDao $adminUserRoleDao, AdminRoleModuleDao $adminRoleModuleDao, AdminModuleDao $adminModuleDao)
    {
        $this->dao = $adminRoleDao;

        $this->adminRoleDao = $adminRoleDao;
        $this->adminUserRoleDao = $adminUserRoleDao;
        $this->adminRoleModuleDao = $adminRoleModuleDao;
        $this->adminModuleDao = $adminModuleDao;
    }

    /**
     * vrati defaultni strankovac
     */
    public function getPaginatorConfig($maxPageSize)
    {
        return $this->adminRoleDao->createDefaultPaginatorConfig($maxPageSize);
    }

    /**
     * vrati aktivni moduly
     */
    public function getPage(PaginatorConfig $config)
    {
        $roles = $this->adminRoleDao->paginate($config);
        foreach ($roles->getPage() as $role) {
            $this->fillAdminRole($role);
        }
        return $roles;
    }

    /**
     * @param integer $id
     * @return AdminRole
     */
    public function get($id)
    {
        $role = $this->adminRoleDao->load($id);
        $this->fillAdminRole($role);
        return $role;
    }

    public function update(AdminRole $role)
    {
        $this->adminRoleDao->update($role);
        $this->saveRoleModules($role);
    }

    public function save(AdminRole $role)
    {
        $id = $this->adminRoleDao->save($role);
        $this->saveRoleModules($role);
        return $id;
    }

    public function delete($id)
    {
        $this->adminRoleDao->delete($id);

        $oldUserRoles = $this->adminUserRoleDao->find(["fkAdminRoleId" => $id])->listResult();
        foreach ($oldUserRoles as $oldUserRole) {
            $this->adminRoleDao->delete($oldUserRole);
        }

        $oldRolesModules = $this->adminRoleModuleDao->find(["fkAdminRoleId" => $id])->listResult();
        foreach ($oldRolesModules as $oldRolesModule) {
            $this->adminRoleModuleDao->delete($oldRolesModule);
        }
    }

    /**
     * @return array<int, AdminModule>
     */
    public function getModules()
    {
        return $this->adminModuleDao->find([], ['name' => OrderBy::ASC])->listResult();
    }

    protected function saveRoleModules(AdminRole $adminRole)
    {
        $oldRoleModules = $this->adminRoleModuleDao->find(["fkAdminRoleId" => $adminRole->getId()])->listResult();
        $oldRoleModulesHash = [];
        foreach ($oldRoleModules as $oldUserModule) {
            $oldRoleModulesHash[$oldUserModule->getFkAdminModuleId()] = $oldUserModule;
        }

        foreach ($adminRole->getModules() as $module) {
            if (isset($oldRoleModulesHash[$module->getId()])) {
                unset($oldRoleModulesHash[$module->getId()]);
            } else {
                $moduleRole = new AdminRoleModule();
                $moduleRole->setFkAdminModuleId($module->getId());
                $moduleRole->setFkAdminRoleId($adminRole->getId());

                $this->adminRoleModuleDao->save($moduleRole);
            }
        }

        foreach ($oldRoleModulesHash as $oldUserModule) {
            $this->adminRoleModuleDao->delete($oldUserModule);
        }
    }

    protected function fillAdminRole(AdminRole $adminRole)
    {
        $modules = $this->adminModuleDao->findRoleModules($adminRole->getId())->listResult();
        $adminRole->setModules($modules);
    }
}
