<?php

namespace IZON\Modules\AdminUsers\Config;

// includuje funkce pro konfiguraci DI
use IZON\Admin\Config;
use IZON\DB\TransactionManagementFactoryObject;
use IZON\DI\DI;
use IZON\Modules\AdminUsers\Admin\Controllers\RoleController;
use IZON\Modules\AdminUsers\Admin\Controllers\UserController;
use IZON\Modules\AdminUsers\Admin\Services\RoleService;
use IZON\Modules\AdminUsers\Admin\Services\UserService;


return [
    'moduleActions' => [
        // jaka akce se ma provest defaultne pri kliknuti na nazev modulu
        'defaultAction' => 'execute',
        // jake akce modul obsahuje a jak se maji pojmenovat
        'actions' => [
            'execute' => [
                'name' => "Uživatelé",
                'controllerId' => 'admin.userController',
                'action' => 'execute',
            ],
            'execute.roles' => [
                'name' => "Role",
                'controllerId' => 'admin.roleController',
                'action' => 'execute',
            ],
        ],
        // jake akce se maji zobrazit v menu
        'menuActions' => ['execute', 'execute.roles']
    ],

    'admin.userServiceBare' => DI::autowire(UserService::class)
        ->constructor(
            DI::get('izon.admin.service.adminSessionService')
        ),

    'admin.userService' => DI::factoryObject(TransactionManagementFactoryObject::class)
        ->constructor(
            DI::get(Config::DEFAULT_DB_CONNECTION_IDENTIFIER),
            Config::moduleGet('admin.userServiceBare')
        ),

    'admin.userController' => DI::autowire(UserController::class)
        ->constructor(
            DI::get('izon.admin.service.adminSessionService'),
            Config::moduleGet('admin.userService'),
            "izon/admin-users-module/users"
        ),

    'admin.roleServiceBare' => DI::autowire(RoleService::class)
        ->constructor(),

    'admin.roleService' => DI::factoryObject(TransactionManagementFactoryObject::class)
        ->constructor(
            DI::get(Config::DEFAULT_DB_CONNECTION_IDENTIFIER),
            Config::moduleGet('admin.roleServiceBare')
        ),

    'admin.roleController' => DI::autowire(RoleController::class)
        ->constructor(
            Config::moduleGet('admin.roleService'),
            "izon/admin-users-module/roles"
        ),
];
