<?php

use IZON\DB\Paginator\PaginatorConfig;
use IZON\Admin\MVC\ModuleInfo;
use IZON\DB\Paginator\PageContent;
use IZON\Admin\Domain\AdminUser;
use IZON\Admin\Domain\AdminRole;

use function PHPView\getParameter;
use function AdminPHPView\getModuleActionURL;
use function AdminPHPView\getPropetryCodeToChange;
use function IZON\String\endsWith;
use function IZON\Arrays\isEmpty;

// soucasny modul
$thisModule = getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER);

/* @var PaginatorConfig $paginatorConfig */
$paginatorConfig = getParameter("paginatorConfig");

/* @var PageContent $pageContent */
$pageContent = getParameter("pageContent");

/** @var AdminUser $adminLoggedUser */
$adminLoggedUser = getParameter("adminLoggedAdminUser");

$editURL = getModuleActionURL($thisModule->getControllerId(), "edit", [], $thisModule->getIdentifier());

$totalCount = $pageContent->getTotalCount();
$maxPageSize = $paginatorConfig->getMaxPageSize();
$firstResult = $paginatorConfig->getFirstResult();

$pagesCout = ceil($totalCount / $maxPageSize);
$currentPage = $firstResult / $maxPageSize + 1;


$filterActive = "";
if(getParameter("filterActive")) {
    $filterActive = " active";
}
$filterForm = getParameter("filterForm");
?>
    <div class="col-xs-12">
        <h1><?= __('Výpis uživatelů') ?></h1>
    </div>

    <div class="col-xs-12" style="padding-top: 10px; padding-bottom: 10px;">
        <a class="btn btn--small btn--mint" href="<?= $editURL ?>"><i class="fas fa-plus"></i><?= __('Přidat') ?></a>
    </div>

    <section class="col-xs-12">
        <div class="table-icons" style="display: none;">
            <i class="fas fa-check" data-fa-symbol="icon--true"></i>
            <i class="fas fa-times" data-fa-symbol="icon--false"></i>
            <i class="fas fa-edit" data-fa-symbol="icon--edit"></i>
            <i class="fas fa-trash-alt" data-fa-symbol="icon--delete"></i>
        </div>
        <table class="table--dynamic">

            <thead>
                <tr>
                    <?php
                    writeListHeaderField($paginatorConfig, "id", __("#"));
                    writeListHeaderField($paginatorConfig, "login", __("Login"));
                    writeListHeaderField($paginatorConfig, "firstName", __("Jméno"));
                    writeListHeaderField($paginatorConfig, "lastName", __("Příjmení"));
                    writeListHeaderField($paginatorConfig, "roles", __("Role"));
                    if($adminLoggedUser->getSuperuser()) {
                        writeListHeaderField($paginatorConfig, "superuser", __("Superuser"));
                    }
                    writeListHeaderField($paginatorConfig, "active", __("Aktivní"));
                    ?>
                    <th style=""><?= __('Funkce') ?></th>
                </tr>
            </thead>
            <tbody id="list-table">
                <?php
                /** @var AdminUser $user */
                foreach($pageContent->getPage() as $user) {
                    if(!$user->getSuperuser() || $adminLoggedUser->getSuperuser()) {
                        $editURL = getModuleActionURL($thisModule->getControllerId(), "edit", ["id" => $user->getId()], $thisModule->getIdentifier());
                        $deleteURL = getModuleActionURL($thisModule->getControllerId(), "delete", ["id" => $user->getId()], $thisModule->getIdentifier());

                        $roles = array_map(function(AdminRole $ar): string {return $ar->getName();}, $user->getRoles());
                        $roles = join(', ', $roles);
                        ?>
                        <tr>
                            <td><?= $user->getId() ?></td>
                            <td><a href="<?= $editURL ?>"><?= $user->getLogin() ?></a></td>
                            <td><a href="<?= $editURL ?>"><?= $user->getFirstName() ?></a></td>
                            <td><a href="<?= $editURL ?>"><?= $user->getLastName() ?></a></td>
                            <td><?= $roles ?></td>
                            <?php if($adminLoggedUser->getSuperuser()) { ?>
                                <td style="text-align: center;"><?= getPropetryCodeToChange($thisModule, $user, 'superuser') ?></td>
                            <?php } ?>
                            <td style="text-align: center;"><?= getPropetryCodeToChange($thisModule, $user, 'active') ?></td>
                            <td style="text-align: center;">
                                <a href="<?= $editURL ?>"><svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--edit"></use></svg></a>
                                <a href="<?= $deleteURL ?>" rel="<?= $user->getId().' '.$user->getFirstName()." ".$user->getLastName() ?>"><svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--delete"></use></svg></a>
                            </td>
                        </tr>
                        <?php
                    }
                }
                ?>
            </tbody>
        </table>

    </section>

    <!-- POPUP - Confirmation of deleting item -->
    <div class="popup">
        <div class="popup__message confirmation-deleting">
            <div class="close"></div>
            <span><?= __('Opravdu chcete smazat záznam') ?> <strong class="zaznam"></strong>?</span>
            <a href="#" class="btn--secondary" id="back"><?= __('Vrátit') ?></a>
            <a href="#" class="btn--important" id="do"><?= __('Smazat') ?></a>
        </div>
    </div>
<?php

function writeListHeaderField(PaginatorConfig $paginatorConfig, $propertyName, $feldName, $width = NULL) {
    $isSortable = $paginatorConfig->isOrderable($propertyName);
    $order = $paginatorConfig->getOrders()[0];

    $classes = [];
    // je raditelny sloupe
    if($isSortable) {
        $classes[] = 'sortable';
        if($order[0] == $propertyName) {
            if($order[1]) {
                $classes[] = "sorted--down";
            } else {
                $classes[] = "sorted--up";
            }
        }
    }

    // sirka sloupecku
    $widthStyle = "";
    if($width != NULL) { // je nastavena nejaka sirka
        if(endsWith($width, "%") || endsWith($width, "px")) { // konci procentem nebo konci pixely
            $widthStyle = "width: ".$width;
        } else {
            throw new Exception("Nepodporovany fomat sirky sloupce. Podporovany jsou % a px");
        }
    }

    echo '<th '.(!isEmpty($classes) ? 'class="'.implode(" ", $classes).'"' : '')
        .' data-property-name="'.$propertyName
        .'" data-order="'.($order[1] ? 'down' : 'up')
        .'" style="'.$widthStyle.'" >
        '.$feldName;
    echo '<span class="sortable__down"></span>';
    echo '<span class="sortable__up"></span>';
    echo '</th>';
}
