<?php

namespace IZON\Modules\AdminUsers\Admin\Controllers;

use IZON\Admin\Domain\AdminRole;
use IZON\Admin\Web\Controllers\AbstractBaseController;
use IZON\DB\Paginator\PaginatorConfig;
use IZON\Forms\Form;
use IZON\Modules\AdminUsers\Admin\Forms\AdminRoleFormFactory;
use IZON\Modules\AdminUsers\Admin\Services\RoleService;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use SebastianBergmann\RecursionContext\Exception;


class RoleController extends AbstractBaseController {

    /** @var RoleService */
    protected $roleService;

    /** @var string name of view to call */
    protected $viewName;

    /** @var int */
    protected $maxPageSize = 1000;

    protected $modulesPreffix = "modules";

    function __construct(RoleService $roleService, $viewName) {
        parent::__construct($roleService);
        $this->roleService = $roleService;
        $this->viewName = $viewName;
    }

    /**
     * execute je defaultni akce, ktera se zavola, pokud neni specifikovana jina metoda
     * @param HttpRequest $request
     * @return ModelAndView
     */
    public function execute(HttpRequest $request) {
        $paginatorConfig = $this->roleService->getPaginatorConfig($this->maxPageSize);

        $modelAndView = new ModelAndView("admin/".$this->viewName."/list");
        $modelAndView->putParameter("paginatorConfig", $paginatorConfig);
        $modelAndView->putParameter("pageContent", $this->roleService->getPage($paginatorConfig));

        return $modelAndView;
    }

    /**
     * zobrazi editacni formular a naplni ho daty
     */
    public function edit(HttpRequest $request) {
        if($request->hasParameter("id")) { // posila se id, musi se editovat odpovidajici objekt
            $role = $this->roleService->get($request->getParameter("id"));
        } else {
            $role = $this->createDomainObject();
        }

        $form = $this->createForm();
        $form->edit($role);

        // modules
        $modulesFormsHash = [];
        $modules = [];
        foreach($this->roleService->getModules() as $module) {
            $moduleForm = $this->createModuleForm([$this->modulesPreffix, $module->getId()], $module->getName());
            $modulesFormsHash[$module->getId()] = $moduleForm;
            $modules[$module->getId()] = $module;
        }

        foreach($role->getModules() as $module) {
            $formModule = $modulesFormsHash[$module->getId()];
            $formModule->getField("hasModule")->serialize(true);
        }

        $modelAndView = new ModelAndView("admin/".$this->viewName."/form");
        $modelAndView->putParameter("form", $form);
        $modelAndView->putParameter("moduleForms", $modulesFormsHash);
        $modelAndView->putParameter("modules", $modules);

        return $modelAndView;
    }

    public function save(HttpRequest $request) {
        $form = $this->createForm();
        $form->setValues($request->getParameters());

        $selectedModules = [];
        foreach($this->roleService->getModules() as $module) {
            $moduleForm = $this->createModuleForm([$this->modulesPreffix, $module->getId()], $module->getName());
            $moduleForm->setValues($request->getParameters());

            if($moduleForm->getField("hasModule")->parse()) {
                $selectedModules[] = $module;
            }
        }

        $isUpdate = false;
        if($request->hasParameter("id") && $request->getParameter("id") != '') {
            $isUpdate = true;
            $role = $this->roleService->get($request->getParameter("id"));
        } else {
            $role = $this->createDomainObject();
        }

        $form->flush($role);
        $role->setModules($selectedModules);

        if($isUpdate) {
            $this->roleService->update($role);
        } else {
            $this->roleService->save($role);
        }

        return new ModelAndView($request->getCalledControllerId(), ['action' => 'execute'], true);;
    }

    public function delete(HttpRequest $request) {
        if(!$request->hasParameter("id")) {
            throw new \Exception("Can't delete. No id provided");
        }

        $id = $request->getParameter("id");
        $this->roleService->delete($id);

        $modelAndView = new ModelAndView($request->getCalledControllerId(), ['action' => 'execute'], true);

        return $modelAndView;
    }


    protected function createForm() {
        return AdminRoleFormFactory::createRoleForm();
    }

    protected function createModuleForm($preffix, $name) {
        return AdminRoleFormFactory::createRoleModuleForm($preffix, $name);
    }

    protected function createDomainObject() {
        $user = new AdminRole();

        $user->setId(NULL);

        return $user;
    }

    protected function getPage(PaginatorConfig $config) {
        // TODO: Implement getPage() method.
    }

    protected function modifyPaginator(PaginatorConfig $paginatorConfig, Form $filterForm) {
        // TODO: Implement modifyPaginator() method.
    }

    protected function getPaginatorSessionIndentifier() {
        // TODO: Implement getPaginatorSessionIndentifier() method.
    }

    protected function createPaginatorConfig() {
        // TODO: Implement createPaginatorConfig() method.
    }

    protected function createFilterForm() {
        // TODO: Implement createFilterForm() method.
    }

}
