<?php

namespace IZON\Modules\AdminUsers\Forms;

use IZON\Forms\Form;

/**
 * factory pro vytvareni formularu pro uzivatel
 */
class UserFormFactory {

    public static function createUserForm() {
        $form = new Form();
        $form->addIdField("id", _("Id"));
        $form->addCharField("name", _("Jméno"));
        $form->addCharField("login", _("Login"));
        $form->addEmailField("email", _("Email"));
        $form->addCheckboxField("active", _("Zobrazovat"));
        
        return $form;
    }
    
    public static function createUserRegistrationForm() {
        $form = new Form();
        $form->addEmailField("email", _("Email"))->setRequired(true);
        $form->addPasswordField("password", _("Heslo"))->setRequired(true);
        $form->addPasswordField("repeatPassword", _("Heslo znova"));
        
        return $form;
    }
    
    public static function createLoginForm() {
        $form = new Form();
        $form->addCharField("login", _("Login"));
        $form->addPasswordField("password", _("Heslo"));
        
        return $form;
    }
    
    public static function createChangePasswordForm() {
        $form = new Form();
        $form->addIdField("id", _("Id"));
        $form->addPasswordField("oldPassword", _("Staré heslo"))->setRequired(true);
        $form->addPasswordField("password", _("Heslo"))->setRequired(true);
        $form->addPasswordField("repeatPassword", _("Heslo znova"));
        
        return $form;
    }
}
