<?php

namespace IZON\Modules\AdminUsers\Admin\Controllers;

use IZON\Admin\Domain\AdminUser;
use IZON\Admin\Web\Controllers\AbstractBaseController;
use IZON\DB\Paginator\PaginatorConfig;
use IZON\Forms\Form;
use IZON\Modules\AdminUsers\Admin\Forms\AdminUserFormFactory;
use IZON\Modules\AdminUsers\Admin\Services\UserService;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use SebastianBergmann\RecursionContext\Exception;

class UserController extends AbstractBaseController {
    /**
     * @var UserService
     */
    protected $userService;
    /**
     *
     * @var string name of view to call
     */
    protected $viewName;
    protected $maxPageSize = 1000;
    protected $rolesPreffix = "roles";

    public function __construct(UserService $userService, $viewName) {
        parent::__construct($userService);
        $this->userService = $userService;
        $this->viewName = $viewName;
    }

    /**
     * execute je defaultni akce, ktera se zavola, pokud neni specifikovana jina metoda
     * @param HttpRequest $request
     * @return ModelAndView
     */
    public function execute(HttpRequest $request) {
        $modelAndView = new ModelAndView("admin/" . $this->viewName . "/list");

        $paginatorConfig = $this->userService->getPaginatorConfig($this->maxPageSize);

        $modelAndView->putParameter("paginatorConfig", $paginatorConfig);

        $modelAndView->putParameter("pageContent", $this->userService->getPage($paginatorConfig));

        return $modelAndView;
    }

    /**
     * zobrazi editacni formular a naplni ho daty
     */
    public function edit(HttpRequest $request) {
        $modelAndView = new ModelAndView("admin/" . $this->viewName . "/form");

        $activeCountries = $this->userService->getActiveCountries();
        $activeLanguages = $this->userService->getActiveLanguages();
        $activeLocales = $this->userService->getActiveLocales();

        $form = $this->createForm($activeCountries, $activeLanguages, $activeLocales);
        $modelAndView->putParameter("form", $form);

        $rolesFormsHash = [];
        $roles = $this->userService->getRoles();
        foreach($roles as $role) {
            $roleForm = $this->createRoleForm([$this->rolesPreffix, $role->getId()], $role->getName());
            $rolesFormsHash[$role->getId()] = $roleForm;
        }
        $modelAndView->putParameter("roleForms", $rolesFormsHash);

        if($request->hasParameter("id")) { // posila se id, musi se editovat odpovidajici objekt
            $id = $request->getParameter("id");

            $object = $this->userService->get($id);
            $form->edit($object);

            foreach($object->getRoles() as $role) {
                /* @var $tags ArticleTag */
                $form = $rolesFormsHash[$role->getId()];
                $form->getField("hasRole")->serialize(true);
            }
        } else {
            $article = $this->createDomainObject();
            $form->edit($article);
        }

        return $modelAndView;
    }

    public function save(HttpRequest $request) {
        $activeCountries = $this->userService->getActiveCountries();
        $activeLanguages = $this->userService->getActiveLanguages();
        $activeLocales = $this->userService->getActiveLocales();

        $form = $this->createForm($activeCountries, $activeLanguages, $activeLocales);
        $form->setValues($request->getParameters());

        $roles = $this->userService->getRoles();
        $selectedRoles = [];
        foreach($roles as $role) {
            $roleForm = $this->createRoleForm([$this->rolesPreffix, $role->getId()], $role->getName());
            $roleForm->setValues($request->getParameters());

            if($roleForm->getField("hasRole")->parse()) {
                $selectedRoles[] = $role;
            }
        }

        if($request->hasParameter("id") && $request->getParameter("id") != '') { // posila se id, musi se editovat odpovidajici objekt
            $id = $request->getParameter("id");

            $object = $this->userService->get($id);
            $oldPasswordHash = $object->getPassword();

            $form->flush($object);

            if($object->getPassword() != '') { // men heslo jen pokud je vyplnene
                $object->setPassword($this->userService->computePasswordHash($object->getPassword()));
            } else {
                $object->setPassword($oldPasswordHash);
            }
            $object->setRoles($selectedRoles);

            $this->userService->update($object);
        } else {
            // TODO: potom odstranit
            $object = $this->createDomainObject();
            $form->flush($object);
            $object->setRoles($selectedRoles);

            // vytvor hash vybraneho hesla
            $object->setPassword($this->userService->computePasswordHash($object->getPassword()));

            $this->userService->save($object);
        }

        // TODO: predavat nejak informaci o this module nebo tak neco a nepouzivat Config
        $modelAndView = new ModelAndView(
            $request->getCalledControllerId(), ['action' => 'execute'], true);

        return $modelAndView;
    }

    public function delete(HttpRequest $request) {
        if(!$request->hasParameter("id")) {
            throw new \Exception("Can't delete. No id provided");
        }

        $id = $request->getParameter("id");
        $this->userService->delete($id);

        // TODO: provide flash message

        $modelAndView = new ModelAndView(
            $request->getCalledControllerId(), ['action' => 'execute'], true);

        return $modelAndView;
    }

    protected function createForm($activeCountries, $activeLanguages, $activeLocales) {
        return AdminUserFormFactory::createUserForm($activeCountries, $activeLanguages, $activeLocales);
    }

    protected function createRoleForm($preffix, $name) {
        return AdminUserFormFactory::createUserRoleForm($preffix, $name);
    }

    protected function createDomainObject() {
        $user = new AdminUser();

        $user->setId(NULL);

        return $user;
    }

    protected function getPage(PaginatorConfig $config) {
        // TODO: Implement getPage() method.
    }

    protected function modifyPaginator(PaginatorConfig $paginatorConfig, Form $filterForm) {
        // TODO: Implement modifyPaginator() method.
    }

    protected function getPaginatorSessionIndentifier() {
        // TODO: Implement getPaginatorSessionIndentifier() method.
    }

    protected function createPaginatorConfig() {
        // TODO: Implement createPaginatorConfig() method.
    }

    protected function createFilterForm() {
        // TODO: Implement createFilterForm() method.
    }


}
