<?php

use IZON\DB\Paginator\PaginatorConfig;

// soucasny modul
$thisModule = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
/* @var $paginatorConfig PaginatorConfig */
$paginatorConfig = PHPView\getParameter("paginatorConfig");
/* @var $pageContent IZON\DB\Paginator\PageContent */
$pageContent = \PHPView\getParameter("pageContent");
?>

<div class="col-xs-12">
    <h1><?= __('Výpis uživatelů') ?></h1>
</div>

<?php
$editURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "edit", [], $thisModule->getIdentifier());



$totalCount = $pageContent->getTotalCount();
$maxPageSize = $paginatorConfig->getMaxPageSize();
$firstResult = $paginatorConfig->getFirstResult();

$pagesCout = ceil($totalCount / $maxPageSize);
$currentPage = $firstResult / $maxPageSize + 1;


$filterActive = "";
if(PHPView\getParameter("filterActive")) {
    $filterActive = " active";
}
$filterForm = PHPView\getParameter("filterForm");

// strankovac
//echo '<div class="page-switcher">'.
//    '<span class="page-switcher__prev"></span>'.
//    '<input name="page" type="number" min="1" max="'.  $pagesCout .'" value="'. $currentPage .'" class="page-switcher__input">'.
//    ' / '.
//    '<span class="page-switcher__page-count">'. $pagesCout .'</span>'.
//    '<span class="page-switcher__next"></span>'.
//'</div>'.
//'<span class="header__filter-button'. $filterActive .'"><span class="turn-off-word">'. __('Vypni ') .'</span>'. __('Filtr') .'</span>'.
//'</div>';
//
////filtr
//echo '<section class="col-xs-12">';
//echo '<form id="list-filter" action="" method="get" class="form--filter'. $filterActive .'">'.
//        '<input type="hidden" name="setFilter" value="1">';
//echo    '<div class="col-xs-12 col-sm-1 col-md-1">'.
//            \IZON\Admin\Forms\getAdminField($filterForm, 'code') .
//        '</div>';
//echo    '<div class="col-xs-12 col-sm-1 col-md-1">'.
//            \IZON\Admin\Forms\getAdminField($filterForm, 'isbn') .
//        '</div>';
//echo    '<div class="col-xs-12 col-sm-6 col-md-6">'.
//            \IZON\Admin\Forms\getAdminField($filterForm, 'name') .
//        '</div>';
//echo    '<div class="col-xs-12 col-sm-2 col-md-2">'.
//            \IZON\Admin\Forms\getAdminField($filterForm, 'authorLastName') .
//        '</div>';
//echo   '<div class="col-xs-12 col-sm-2 col-md-2">'.
//            \IZON\Admin\Forms\getAdminField($filterForm, 'activeOnly') .
//        '</div>';
//echo '</form>';
//echo '</section>';
?>
<div class="col-xs-12" style="padding-top: 10px; padding-bottom: 10px;">
    <a class="btn btn--small btn--mint" href="<?= $editURL ?>"><i class="fas fa-plus"></i><?= __('Přidat') ?></a>
</div>
 

<section class="col-xs-12">
    <div class="table-icons" style="display: none;">
        <i class="fas fa-check" data-fa-symbol="icon--true"></i>
        <i class="fas fa-times" data-fa-symbol="icon--false"></i>
        <i class="fas fa-edit" data-fa-symbol="icon--edit"></i>
        <i class="fas fa-trash-alt" data-fa-symbol="icon--delete"></i>
    </div> 
    <table class="table--dynamic">

        <thead>
            <tr>
                <?php
                writeListHeaderField($paginatorConfig, "id", __("#"));
                writeListHeaderField($paginatorConfig, "login", __("Login"));
                writeListHeaderField($paginatorConfig, "firstName", __("Jméno"));
                writeListHeaderField($paginatorConfig, "lastName", __("Příjmení"));
                writeListHeaderField($paginatorConfig, "superuser", __("Superuser"));
                writeListHeaderField($paginatorConfig, "active", __("Aktivní"));
                ?>
                <th style="">Funkce</th>
            </tr>
        </thead>
        <tbody id="list-table">
            <?php
            foreach($pageContent->getPage() as $obj) {
                /* @var $obj IZON\Admin\Domain\AdminUser */
                $editURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "edit", ["id" => $obj->getId()], $thisModule->getIdentifier());
                $deleteURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "delete", ["id" => $obj->getId()], $thisModule->getIdentifier());
                ?>
                <tr>
                    <td><?= $obj->getId() ?></td>
                    <td><a href="<?= $editURL ?>"><?= $obj->getLogin() ?></a></td>
                    <td><a href="<?= $editURL ?>"><?= $obj->getFirstName() ?></a></td>
                    <td><a href="<?= $editURL ?>"><?= $obj->getLastName() ?></a></td>
                    <td>
                        <?= AdminPHPView\getPropetryCodeToChange($thisModule, $obj, 'superuser') ?>
                    </td>
                    <td>
                        <?= AdminPHPView\getPropetryCodeToChange($thisModule, $obj, 'active') ?>
                    </td>
                    <td>
                        <a href="<?= $editURL ?>" ><svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--edit"></use></svg></a>
                        <a href="<?= $deleteURL ?>" rel="<?= $obj->getId() . ' ' . $obj->getFirstName() . " " . $obj->getLastName() ?>"><svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--delete"></use></svg></a>
                    </td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>

    <?php
//
//// strankovac
//echo '<div class="col-xs-12 row-controlls">'.
//'<div class="page-switcher">'.
//    '<span class="page-switcher__prev"></span>'.
//    '<input name="page" type="number" min="1" max="'.  $pagesCout .'" value="'. $currentPage .'" class="page-switcher__input">'.
//    ' / '.
//    '<span class="page-switcher__page-count">'. $pagesCout .'</span>'.
//    '<span class="page-switcher__next"></span>'.
//'</div>'.
//'</div>';
    ?>

</section>

<!-- POPUP - Confirmation of deleting item -->
<div class="popup">
    <div class="popup__message confirmation-deleting">
        <div class="close"></div>
        <span><?= __('Opravdu chcete smazat záznam') ?> <strong class="zaznam"></strong>?</span>
        <a href="#" class="btn--secondary" id="back"><?= __('Vrátit') ?></a>
        <a href="#" class="btn--important" id="do"><?= __('Smazat') ?></a>
    </div>
</div>

</div><?php // <div class="col-xs-12 row-controlls">     ?>

<?php

function writeListHeaderField(PaginatorConfig $paginatorConfig, $propertyName, $feldName, $width = NULL) {
    $isSortable = $paginatorConfig->isOrderable($propertyName);
    $order = $paginatorConfig->getOrders()[0];

    $classes = [];
    // je raditelny sloupe
    if($isSortable) {
        $classes[] = 'sortable';
        if($order[0] == $propertyName) {
            if($order[1]) {
                $classes[] = "sorted--down";
            } else {
                $classes[] = "sorted--up";
            }
        }
    }
    // sirka sloupecku
    $widthStyle = "";
    if($width != NULL) { // je nastavena nejaka sirka 
        if(IZON\String\endsWith($width, "%") // konci procentem
                || IZON\String\endsWith($width, "px")) { // konci pixely
            $widthStyle = "width: " . $width;
        } else {
            throw new Exception("Nepodporovany fomat sirky sloupce. Podporovany jsou % a px");
        }
    }

    echo '<th ' . (!IZON\Arrays\isEmpty($classes) ? 'class="' . implode(" ", $classes) . '"' : '')
    . ' data-property-name="' . $propertyName
    . '" data-order="' . ($order[1] ? 'down' : 'up')
    . '" style="' . $widthStyle . '" >
        ' . $feldName;
    echo '<span class="sortable__down"></span>';
    echo '<span class="sortable__up"></span>';
    echo '</th>';
}
