<?php

$thisModule = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
/* @var $pageContent IZON\DB\Paginator\PageContent */
$pageContent = \PHPView\getParameter("pageContent");
/* @var $paginatorConfig PaginatorConfig */
$paginatorConfig = PHPView\getParameter("paginatorConfig");

$totalCount = $pageContent->getTotalCount();
$maxPageSize = $paginatorConfig->getMaxPageSize();
$firstResult = $paginatorConfig->getFirstResult();

$pagesCount = ceil($totalCount/$maxPageSize);
$currentPage = $firstResult/$maxPageSize + 1;
//var_dump($currentPage);

$response = [
    "pagesCount" => $pagesCount,
    "currentPage" => $currentPage,
    "page" => []
];


/* @var $filterForm \IZON\Forms\Form */
$filterForm = PHPView\getParameter("filterForm");
if($filterForm) {
    $formFields = [];
    foreach($filterForm->getFileds() as $filed) {
        $formFields[] = ["name" => $filed->getFormName(), "value" => $filed->getValue()];
    }
    $response["filterValues"] = $formFields;
}

//var_dump($response);

foreach($pageContent->getPage() as $obj) {
    /* @var IZON\Catalog\Domain\Product $obj */
  $editURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(),
                                                        "edit",
                                                        ["id" => $obj->getId()],
                                                        $thisModule->getIdentifier());
  $deleteURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(),
                                                        "delete",
                                                        ["id" => $obj->getId()],
                                                        $thisModule->getIdentifier());
  
  $firstAuthorName = "";
  if( count($obj->getProductAuthors()) > 0 ) {
    $firstAuthor = $obj->getProductAuthors()[0];
    $firstAuthor = trim($firstAuthor->getFirstName() ." ". $firstAuthor->getLastName());
  }
  $product = [
      'id' => $obj->getId(),
      'code' => $obj->getCode(),
      'isbn' => $obj->getISBN(),
      'name' => $obj->getName(),
      'authorName' => $firstAuthor,
      'active' => $obj->getActive(),
      
      'editURL' => $editURL,
      'deleteURL' => $deleteURL,
  ];
  
  $response["page"][] = $product;
//  
//echo '<tr>'.
//        '<td>'. $obj->getId() .'</td>'.
//        '<td>'. $obj->getCode() .'</td>'.
//        '<td>'. $obj->getISBN() .'</td>'.
//        '<td><a href="'.$editURL.'">'.$obj->getName().'</a></td>'.
//        '<td>'.$obj->getSubTitle().'</td>'.
//        '<td>'.
//            (($obj->getActive())?'<div class="true"></div>':'<div class="false"></div>').
//        '</td>'.
//        '<td>'.
//            '<a href="'.$editURL.'" class="fce--edit"></a>'.
//            '<a href="'.$deleteURL.'" class="fce--delete" rel="'.$obj->getName().'"></a>'.
//        '</td>'.
//    '</tr>';
}

echo json_encode($response);