<?php

// includuje funkce pro konfiguraci DI
use function IZON\DI\get;
use function IZON\DI\object;
use function IZON\DI\factory;
// includuje funkce pro konfiguraci DI
use function IZON\Admin\DI\moduleGet;

use IZON\Admin\Config;

use IZON\DB\TransactionManagementFactoryBean;

use IZON\Modules\AdminUsers\Admin\Services\UserService;
use IZON\Modules\AdminUsers\Admin\Controllers\UserController;

use IZON\Modules\AdminUsers\Admin\Services\RoleService;
use IZON\Modules\AdminUsers\Admin\Controllers\RoleController;

$dbConnIdentifier = Config::DEFAULT_DB_CONNECTION_IDENTIFIER;

return [
    'moduleActions' => [
        // jaka akce se ma provest defaultne pri kliknuti na nazev modulu
        'defaultAction' => 'execute', 
        // jake akce modul obsahuje a jak se maji pojmenovat
        'actions' => [
            'execute' => [
                'name' => "Uživatelé", 
                'controllerId' => 'admin.userController',
                'action' => 'execute',
            ],
            'execute.roles' => [
                'name' => "Role", 
                'controllerId' => 'admin.roleController',
                'action' => 'execute',
            ],
        ],
        // jake akce se maji zobrazit v menu
        'menuActions' => ['execute', 'execute.roles']
        
    ],
    
    'admin.userServiceBare' => object(UserService::class)
                                            ->constructor(get('izon.admin.service.adminSessionService')),
    'admin.userService' => object(TransactionManagementFactoryBean::class)
                                                ->constructor(get($dbConnIdentifier), 
                                                        moduleGet('admin.userServiceBare')
                                                    ),
    'admin.userController' => object(UserController::class)
                                                        ->constructor( moduleGet('admin.userService'),
                                                              "izon/admin-users-module/users" ),
    
    'admin.roleServiceBare' => object(RoleService::class)
                                            ->constructor(),
    'admin.roleService' => object(TransactionManagementFactoryBean::class)
                                                ->constructor(get($dbConnIdentifier), 
                                                        moduleGet('admin.roleServiceBare')
                                                    ),
    'admin.roleController' => object(RoleController::class)
                                                        ->constructor( moduleGet('admin.roleService'),
                                                              "izon/admin-users-module/roles" ),
];