<?php
use IZON\Catalog\Domain\ProductAttribute;

$thisModule = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
$base = AdminPHPView\getModuleActionURL('admin.controllers.authorController',
                                            "autorsByName",
                                            [],
                                            $thisModule->getIdentifier());
$swap = explode('.', $base);
?>
<script type="text/javascript">
    var ajaxInterfaceLinkBase = '<?=  str_replace(end($swap), '', $base)?>'
  
    var usedId = new Array();
    function getNewId() {
        var swap;
        var ret = true;
        do {
            swap = Math.floor(Math.random() * 1000000);
        } while(isItemInArray(swap, usedId));

        usedId.push(swap);
        return swap;
    }
    function isItemInArray(searchedItem, field) {
        var ret = false;
        for (var item in field) {
            if (field[item] == searchedItem) {
                ret = true;
                break;
            }
        }
        return ret;
    }

// prida novou otazku
    function addNewProductVariant() {
        var tr;
        var x = getNewId();
        tr = '<div class="form__item--100 form__item--container">'+
                    '<span class="heading"><?= __("Varianta") ?></span>';
        
        tr = tr +'<div class="form__item--100">'+
                    '<label>Název: </label>'+
                    '<input name="variants['+ x +'][name]" type="text">'+
                '</div><div class="form__item--50">'+
                    '<label>Cena s DPH: </label>'+
                    '<input name="variants['+ x +'][priceWithVat]" type="number" step="1" >'+
                '</div><div class="form__item--50">'+
                    '<label>Nákupní cena s DPH: </label>'+
                    '<input name="variants['+ x +'][buyingPriceWithVat]" type="number" step="1" >'+
                '</div><div class="form__item--50">'+
                    '<label>Množství: </label>'+
                    '<input name="variants['+ x +'][quantity]" type="number" step="1" >'+
                '</div><div class="form__item--50">'+
                    '<input  id="checkbox--variants['+ x +'][active]" name="variants['+ x +'][active]" checked type="checkbox" >'+
                    '<label for="checkbox--variants['+ x +'][active]">Zobrazovat</label>'+
                '</div><div class="form__item--50">'+
                    '<label>Datum přidání: </label>'+
                    '<input name="variants[0][addedDate]" type="date">'+
                '</div><div class="form__item--100">'+
                    '<label>Propis: </label>'+
                    '<textarea name="variants['+ x +'][description]" rows="5" ></textarea>'+
                '</div>';
                
            <?php
                $productAttributes = \PHPView\getParameter("productAttributes");
                foreach($productAttributes as $productAttribute) {
                    /* @var $productAttribute ProductAttribute */
                    $options = "";
                    foreach($productAttribute->getProductAttributeValues() as $values) {
                        $options .= '<option value="'. $values->getId() .'">'. $values->getName() .'</option>';
                    }
            ?>        
            tr = tr +'<div class="form__item--50">'+
                        '<label><?= $productAttribute->getName(); ?>: </label>'+
                        '<select  name="variants['+ x +'][attributes][0][productAttribute]">'+
                        '<?= $options ?>'+
                        '</select>'+
                    '</div>'
            <?php
            }
            ?>    
        tr = tr +'<div class="form__item--50">'+
                    '<label>Popis stavu: </label>'+
                    '<input name="variants[1][qualityDescription]" value="" type="text">'+
                '</div>';        
        tr = tr +'<button type="button" onclick="removeRow(this.parentNode);" src="../custom/admin/images/delete.gif" width="18" height="16" alt="" class="">Odebrat</button>';
        tr = tr +'</div>';

        $("#variants-container").append(tr);
    }

// odstrani radek
function removeRow(element) {
    element.parentNode.removeChild(element);
}


// pridani kategorie
function addCategory(categoryId, categoryPath) {
    var tr = '<tr><td><input type="hidden" name="categories[]" value="'+ categoryId +'" >' + categoryPath + '</td><td><button type="button" onClick="removeRow(this.parentNode.parentNode)">Odebrat</button></td></tr>'; 
    var table = $('#product-categories-table');
    table.append(tr);
}   


// pridani autora
var authorsControllerLink = "<?= AdminPHPView\getModuleActionURL('admin.controllers.authorController',
                                            "autorsByName",
                                            [],
                                            $thisModule->getIdentifier()); ?>"

/**
 * 
 * @param {type} params
 * @param {type} elem
 * @returns {undefined}
 */
function ajax_loadAuthors() {
    filter = {};
    filter.firstNamePart = $('[name="firstNamePart"]').val();
    filter.lastNamePart = $('[name="lastNamePart"]').val();
    
    $.getJSON(authorsControllerLink, filter, function (data) {
        var table = $('#new-product-authors-table');
        var html = '';
        $.each(data, function (index, value) {
            html += '<tr><td>' + value["firstName"] + '</td><td>' + value["lastName"] + '</td><td><a href="javascript:addNewAuthor(' + value["id"] + ', \'' + value["firstName"] + '\', \'' + value["lastName"] + '\')">Přidat</a></td></tr>';
        });
        table.html(html);
    });
}

function addNewAuthor(id, firstName, lastName) {
    var table = $('#product-authors-table');
    var html = '<tr><td><input type="hidden" name="productAuthors[]" value="'+ id +'">'+ firstName +'</td><td>'+ lastName +'</td><td><button type="button" onclick="removeRow(this.parentNode.parentNode);">Odebrat</button></td></td>';
    table.append(html);
}

// pridani ilustratora
var illustratorsControllerLink = "<?= AdminPHPView\getModuleActionURL('admin.controllers.illustratorController',
                                            "illustratorsByName",
                                            [],
                                            $thisModule->getIdentifier()); ?>"

/**
 * 
 * @param {type} params
 * @param {type} elem
 * @returns {undefined}
 */
function ajax_loadIllustrators() {
    filter = {};
    filter.firstNamePart = $('[name="firstNamePart"]').val();
    filter.lastNamePart = $('[name="lastNamePart"]').val();

    $.getJSON(illustratorsControllerLink, filter, function (data) {
        var table = $('#new-product-illustrators-table');
        var html = '';
        $.each(data, function (index, value) {
            html += '<tr><td>' + value["firstName"] + '</td><td>' + value["lastName"] + '</td><td><a href="javascript:addNewIllustrator(' + value["id"] + ', \'' + value["firstName"] + '\', \'' + value["lastName"] + '\')">Přidat</a></td></tr>';
        });
        table.html(html);
    });
}

function addNewIllustrator(id, firstName, lastName) {
    var table = $('#product-illustrators-table');
    var html = '<tr><td><input type="hidden" name="productIllustrators[]" value="'+ id +'">'+ firstName +'</td><td>'+ lastName +'</td><td><button type="button" onclick="removeRow(this.parentNode.parentNode);">Odebrat</button></td></td>';
    table.append(html);
}
</script>