<?php
namespace IZON\Modules\AdminUsers\Admin\Services;

use IZON\DB\Paginator\PaginatorConfig;
use IZON\DB\OrderBy;

use IZON\Admin\Dao\AdminRoleDao;
use IZON\Admin\Dao\AdminUserRoleDao;
use IZON\Admin\Dao\AdminRoleModuleDao;

use IZON\Admin\Domain\AdminRole;
use IZON\Admin\Domain\AdminUserRole;

/**
 * servis pro zpracovani referenci
 */
class RoleService {    

    /**
     * @var AdminRoleDao 
     */
    protected $adminRoleDao;

    /**
     * @var AdminUserRoleDao
     */
    protected $adminUserRoleDao;

    /**
     * @var AdminRoleModuleDao
     */
    protected $adminRoleModuleDao;
    

/// generovany konstruktor    
    function __construct(AdminRoleDao $adminRoleDao, AdminUserRoleDao $adminUserRoleDao, AdminRoleModuleDao $adminRoleModuleDao) {
        $this->adminRoleDao = $adminRoleDao;
        $this->adminUserRoleDao = $adminUserRoleDao;
        $this->adminRoleModuleDao = $adminRoleModuleDao;
    }
    
    /**
     * vrati defaultni strankovac
     */
    public function getPaginatorConfig($maxPageSize) {
        return $this->adminRoleDao->createDefaultPaginatorConfig($maxPageSize);
    }
    
    /**
     * vrati aktivni moduly
     */
    public function getPage(PaginatorConfig $config) {
        return $this->adminRoleDao->paginate($config);
    }
    
    /**
     * @param integer $id
     * @return AdminUser
     */
    public function get($id) {
        $user = $this->adminRoleDao->load($id);
        return $user;
    }
    
    public function update(AdminRole $obj) {
        $this->adminRoleDao->update($obj);
    }
    
    public function save(AdminRole $obj) {
        $id = $this->adminRoleDao->save($obj);
        return $id;
    }

    public function delete($id) {
        $this->adminRoleDao->delete($id);
        
        $oldUserRoles = $this->adminUserRoleDao->find(["fkAdminRoleId" => $id])->listResult();
        foreach($oldUserRoles as $oldUserRole) {
            $this->adminRoleDao->delete($oldUserRole);
        }
        
        $oldRolesModules = $this->adminRoleModuleDao->find(["fkAdminRoleId" => $id])->listResult();
        foreach($oldRolesModules as $oldRolesModule) {
            $this->adminRoleModuleDao->delete($oldRolesModule);
        }
    }
}