<?php
use IZON\DB\Paginator\PaginatorConfig;

// soucasny modul
$thisModule = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
/* @var $paginatorConfig PaginatorConfig */
$paginatorConfig = PHPView\getParameter("paginatorConfig");
/* @var $pageContent IZON\DB\Paginator\PageContent */
$pageContent = \PHPView\getParameter("pageContent");


?>

<div class="col-xs-12">
    <h1><?= __('Výpis uživatelů')?></h1>
</div>

<?php

$editURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(),
                                                                "edit",
                                                                [],
                                                                $thisModule->getIdentifier());



$totalCount = $pageContent->getTotalCount();
$maxPageSize = $paginatorConfig->getMaxPageSize();
$firstResult = $paginatorConfig->getFirstResult();

$pagesCout = ceil($totalCount/$maxPageSize);
$currentPage = $firstResult/$maxPageSize + 1;


echo '<div class="col-xs-12 row-controlls">'.
 '<div class="fast-nav" style="display: inline-block; width: 100%;">'.
    '<a class="header__fast-nav--add" href="'. $editURL .'">'.__('Přidat').'</a>'.
 '</div>';


$filterActive = "";
if( PHPView\getParameter("filterActive") ) {
    $filterActive = " active";
}
$filterForm = PHPView\getParameter("filterForm");

// strankovac
//echo '<div class="page-switcher">'.
//    '<span class="page-switcher__prev"></span>'.
//    '<input name="page" type="number" min="1" max="'.  $pagesCout .'" value="'. $currentPage .'" class="page-switcher__input">'.
//    ' / '.
//    '<span class="page-switcher__page-count">'. $pagesCout .'</span>'.
//    '<span class="page-switcher__next"></span>'.
//'</div>'.
//'<span class="header__filter-button'. $filterActive .'"><span class="turn-off-word">'. __('Vypni ') .'</span>'. __('Filtr') .'</span>'.
//'</div>';
//
////filtr
//echo '<section class="col-xs-12">';
//echo '<form id="list-filter" action="" method="get" class="form--filter'. $filterActive .'">'.
//        '<input type="hidden" name="setFilter" value="1">';
//echo    '<div class="col-xs-12 col-sm-1 col-md-1">'.
//            \IZON\Admin\Forms\getAdminField($filterForm, 'code') .
//        '</div>';
//echo    '<div class="col-xs-12 col-sm-1 col-md-1">'.
//            \IZON\Admin\Forms\getAdminField($filterForm, 'isbn') .
//        '</div>';
//echo    '<div class="col-xs-12 col-sm-6 col-md-6">'.
//            \IZON\Admin\Forms\getAdminField($filterForm, 'name') .
//        '</div>';
//echo    '<div class="col-xs-12 col-sm-2 col-md-2">'.
//            \IZON\Admin\Forms\getAdminField($filterForm, 'authorLastName') .
//        '</div>';
//echo   '<div class="col-xs-12 col-sm-2 col-md-2">'.
//            \IZON\Admin\Forms\getAdminField($filterForm, 'activeOnly') .
//        '</div>';
//echo '</form>';
//echo '</section>';

?>

<section class="col-xs-12">
<table>
<thead>
    <tr>
        <?php
        writeListHeaderField($paginatorConfig, "id", __("#"), "80px");
        writeListHeaderField($paginatorConfig, "login", __("Login"));
        writeListHeaderField($paginatorConfig, "firstName", __("Jméno"));
        writeListHeaderField($paginatorConfig, "lastName", __("Příjmení"));
        writeListHeaderField($paginatorConfig, "superuser", __("Superuser"), "90px");
        writeListHeaderField($paginatorConfig, "active", __("Aktivní"), "90px");
        ?>
        <th style="width: 60px">Funkce</th>
    </tr>
</thead>
<tbody id="list-table">
<?php
foreach($pageContent->getPage() as $obj) {
    /* @var $obj IZON\Admin\Domain\AdminUser */
    $editURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(),
                                                          "edit",
                                                          ["id" => $obj->getId()],
                                                          $thisModule->getIdentifier());
    $deleteURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(),
                                                          "delete",
                                                          ["id" => $obj->getId()],
                                                          $thisModule->getIdentifier());
    
    echo '<tr>'.
        '<td>'. $obj->getId() .'</td>'.
        '<td><a href="'.$editURL.'">'.$obj->getLogin().'</a></td>'.
        '<td><a href="'.$editURL.'">'.$obj->getFirstName().'</a></td>'.
        '<td><a href="'.$editURL.'">'.$obj->getLastName().'</a></td>'.
        '<td>'.
            (($obj->getSuperuser())?'<div class="true"></div>':'<div class="false"></div>').
        '</td>'.
        '<td>'.
            (($obj->getActive())?'<div class="true"></div>':'<div class="false"></div>').
        '</td>'.
        '<td>'.
            '<a href="'.$editURL.'" class="fce--edit"></a>'.
            '<a href="'.$deleteURL.'" class="fce--delete" rel="'. $obj->getId() .' '. $obj->getFirstName() ." ". $obj->getLastName() .'"></a>'.
        '</td>'.
    '</tr>';
}
        ?>
    </tbody>
</table>

<?php 
//
//// strankovac
//echo '<div class="col-xs-12 row-controlls">'.
//'<div class="page-switcher">'.
//    '<span class="page-switcher__prev"></span>'.
//    '<input name="page" type="number" min="1" max="'.  $pagesCout .'" value="'. $currentPage .'" class="page-switcher__input">'.
//    ' / '.
//    '<span class="page-switcher__page-count">'. $pagesCout .'</span>'.
//    '<span class="page-switcher__next"></span>'.
//'</div>'.
//'</div>';
?>

</section>

<!-- POPUP - Confirmation of deleting item -->
<div class="popup">
    <div class="popup__message confirmation-deleting">
        <div class="close"></div>
        <span><?=__('Opravdu chcete smazat záznam')?> <strong class="zaznam"></strong>?</span>
        <a href="#" class="btn--secondary" id="back"><?=__('Vrátit')?></a>
        <a href="#" class="btn--important" id="do"><?=__('Smazat')?></a>
    </div>
</div>

</div><?php // <div class="col-xs-12 row-controlls"> ?>

<?php

function writeListHeaderField(PaginatorConfig $paginatorConfig, $propertyName, $feldName, $width = NULL) {
    $isSortable = $paginatorConfig->isOrderable($propertyName);
    $order = $paginatorConfig->getOrders()[0];
    
    $classes = [];
    // je raditelny sloupe
    if( $isSortable ) {
        $classes[] = 'sortable';
        if( $order[0] == $propertyName ) {
            if(  $order[1] ) {
                $classes[] = "sorted--down";
            }  else {
                $classes[] = "sorted--up";
            }
        }  
    }
    // sirka sloupecku
    $widthStyle = "";
    if( $width != NULL ) { // je nastavena nejaka sirka 
        if(IZON\String\endsWith($width, "%") // konci procentem
            || IZON\String\endsWith($width, "px") ) { // konci pixely
            $widthStyle = "width: ". $width;
        } else {
            throw new Exception("Nepodporovany fomat sirky sloupce. Podporovany jsou % a px");
        }
    }
    
    echo '<th '. ( !IZON\Arrays\isEmpty($classes) ? 'class="'. implode(" ", $classes) .'"' : '') 
         .' data-property-name="'. $propertyName 
         .'" data-order="'. ($order[1] ? 'down' : 'up') 
         .'" style="'. $widthStyle .'" >
        '. $feldName;
    echo '<span class="sortable__down"></span>';
    echo '<span class="sortable__up"></span>';
    echo '</th>';
}