<?php

namespace IZON\AdminUsers\Admin\Forms;

use IZON\Forms\Form;

/**
 * factory pro vytvareni formularu pro uzivatel
 */
class AdminUserFormFactory {

    public static function createUserForm(array $activeCountries, array $activeLanguages, array $activeLocales) {
        $countriesOptions = [];
        foreach($activeCountries as $activeCountry) {
            $countriesOptions[$activeCountry->getId()] = $activeCountry->getName();
        }
        
        $langagesOptions = [];
        foreach($activeLanguages as $activeLanguage) {
            $langagesOptions[$activeLanguage->getId()] = $activeLanguage->getName();
        }
        
        $localesOptions = [];
        foreach($activeLocales as $activeLocale) {
            $localesOptions[$activeLocale->getId()] = $activeLocale->getLocaleTag();
        }
        
        $form = new Form();
        $form->addIdField("id", _("Id"));
        $form->addCharField("firstName", _("Jméno"));
        $form->addCharField("lastName", _("Příjmení"));
        $form->addCharField("login", _("Login"));
        $form->addPasswordField("password", _("Nové heslo"));
        $form->addCheckboxField("active", _("Aktivní"));
        $form->addCheckboxField("superuser", _("Superuser"));
        
        $form->addSelectField("fkCountryId", __("Země"))->setOptions($countriesOptions);
        $form->addSelectField("fkLanguageId", __("Jazyk"))->setOptions($langagesOptions);
        $form->addSelectField("fkInterfaceLocaleId", __("Locale rozhraní"))->setOptions($localesOptions);
        
        return $form;
    }
    
    public static function createUserRoleForm($preffix, $tagName) {
        $form = new Form($preffix);
        $form->addCheckboxField("hasRole", $tagName)->setUseLabel(false);
        
        return $form;
    }
    
    public static function createRoleForm() {
        $form = new Form();
        $form->addIdField("id", _("Id"));
        $form->addCharField("name", _("Název"));
        $form->addTextField("description", _("Popis"));
        
        return $form;
    }
}
