<?php
namespace IZON\AdminUsers\Admin\Controllers;

use \IZON\Utils\Date;

use \IZON\MVC\Controller;
use \IZON\MVC\HttpRequest;
use \IZON\MVC\ModelAndView;

use IZON\Forms\Form;

use IZON\AdminUsers\Admin\Forms\AdminUserFormFactory;

use IZON\AdminUsers\Admin\Services\RoleService;

use IZON\Admin\Domain\AdminRole;


class RoleController {
    
    /**
     * @var RoleService 
     */
    protected $roleService;
    
    /**
     *
     * @var string name of view to call 
     */
    protected $viewName;

    protected $maxPageSize = 1000;
    
    
    function __construct(RoleService $roleService, $viewName) {
        $this->roleService = $roleService;
        $this->viewName = $viewName;
    }

    
    /**
     * execute je defaultni akce, ktera se zavola, pokud neni specifikovana jina metoda
     * @param HttpRequest $request
     * @return ModelAndView
     */
    public function execute(HttpRequest $request) {
        $modelAndView = new ModelAndView("admin/". $this->viewName ."/list");
        
        $paginatorConfig = $this->roleService->getPaginatorConfig($this->maxPageSize);
        
        $modelAndView->putParameter("paginatorConfig", $paginatorConfig);
                
        $modelAndView->putParameter("pageContent", 
                                    $this->roleService->getPage($paginatorConfig));
        
        return $modelAndView;
    }
    
    /**
     * zobrazi editacni formular a naplni ho daty
     */
    public function edit(HttpRequest $request) {
        $modelAndView = new ModelAndView("admin/". $this->viewName ."/form");
        
        $form = $this->createForm();
        $modelAndView->putParameter("form", $form);
        
        if( $request->hasParameter("id") ) { // posila se id, musi se editovat odpovidajici objekt
            $id = $request->getParameter("id");
            
            $object = $this->roleService->get($id);
            $form->edit($object);
        } else {
            $article = $this->createDomainObject();
            $form->edit($article);
        }
        
        return $modelAndView;
    }
    
    public function save(HttpRequest $request) {
        $form = $this->createForm();
        $form->setValues($request->getParameters());
        
        if( $request->hasParameter("id")
            && $request->getParameter("id") != '' ) { // posila se id, musi se editovat odpovidajici objekt
            $id = $request->getParameter("id");
            
            $object = $this->roleService->get($id);
            $form->flush($object);
            
            $this->roleService->update($object);
        } else {
            // TODO: potom odstranit
            $object = $this->createDomainObject();
            $form->flush($object);
            
            $this->roleService->save($object);
        }

        // TODO: predavat nejak informaci o this module nebo tak neco a nepouzivat Config
        $modelAndView = new ModelAndView(
                     $request->getCalledControllerId(),
                     ['action' => 'execute'], true);
        
        return $modelAndView;
    }
    
    public function delete(HttpRequest $request) {
        if( !$request->hasParameter("id") ) {
            throw new Exception("Can't delete. No id provided");
        }
        
        $id = $request->getParameter("id");
        $this->roleService->delete($id);
        
        $modelAndView = new ModelAndView(
                    $request->getCalledControllerId(),
                    ['action' => 'execute'], true);
        
        return $modelAndView;
    }
    
    
    protected function createForm() {
        return AdminUserFormFactory::createRoleForm();
    }
    
    protected function createDomainObject() {
        $user = new AdminRole();
        
        $user->setId(NULL);
        
        return $user;
    }
    
}