<?php

// includuje funkce pro konfiguraci DI
use function IZON\DI\get;
use function IZON\DI\object;
use function IZON\DI\factory;
// includuje funkce pro konfiguraci DI
use function IZON\Admin\DI\moduleGet;

use IZON\Admin\Config;

use IZON\DB\TransactionManagementFactoryBean;

use IZON\AdminUsers\Admin\Services\UserService;
use IZON\AdminUsers\Admin\Controllers\UserController;

use IZON\AdminUsers\Admin\Services\RoleService;
use IZON\AdminUsers\Admin\Controllers\RoleController;

$dbConnIdentifier = Config::DEFAULT_DB_CONNECTION_IDENTIFIER;

return [
    'moduleActions' => [
        // jaka akce se ma provest defaultne pri kliknuti na nazev modulu
        'defaultAction' => 'execute', 
        // jake akce modul obsahuje a jak se maji pojmenovat
        'actions' => [
            'execute' => [
                'name' => "Uživatelé", 
                'controllerId' => 'admin.controllers.userController',
                'action' => 'execute',
            ],
            'execute.roles' => [
                'name' => "Role", 
                'controllerId' => 'admin.controllers.roleController',
                'action' => 'execute',
            ],
        ],
        // jake akce se maji zobrazit v menu
        'menuActions' => ['execute', 'execute.roles']
        
    ],
    
    'admin.services.userServiceBare' => object(UserService::class)
                                            ->constructor(get('izon.admin.service.adminSessionService')),
    'admin.services.userService' => object(TransactionManagementFactoryBean::class)
                                                ->constructor(get($dbConnIdentifier), 
                                                        moduleGet('admin.services.userServiceBare')
                                                    ),
    'admin.controllers.userController' => object(UserController::class)
                                                        ->constructor( moduleGet('admin.services.userService'),
                                                              "izon/admin-users/user" ),
    
    'admin.services.roleServiceBare' => object(RoleService::class)
                                            ->constructor(),
    'admin.services.roleService' => object(TransactionManagementFactoryBean::class)
                                                ->constructor(get($dbConnIdentifier), 
                                                        moduleGet('admin.services.roleServiceBare')
                                                    ),
    'admin.controllers.roleController' => object(RoleController::class)
                                                        ->constructor( moduleGet('admin.services.roleService'),
                                                              "izon/admin-users/role" ),
];