$(document).ready(function () {
    formValidation();
    sliderInit();
    formErrorsInit();
});

function sliderInit() {

    $('.slider-range').each(function () {

        var my_min = Number($(this).attr('min'));
        var my_max = Number($(this).attr('max'));
        var my_step = Number($(this).attr('step'));
        var my_unit = $(this).attr('unit');
        var my_input = $(this).attr('for');

        $('#' + my_input).val((my_min + my_step) + ' ' + my_unit + ' - ' + (my_max - my_step) + ' ' + my_unit);

        $(this).slider({
            range: true,
            min: my_min,
            max: my_max,
            step: my_step,
            values: [my_min + my_step, my_max - my_step],
            slide: function (event, ui) {
                $('#' + my_input).val(ui.values[0] + ' ' + my_unit + ' - ' + ui.values[1] + ' ' + my_unit);
            }
        });
    });

}

function formErrorsInit() {
    $('form .error .message').each(function () {
        $(this).prepend('<i class="fas fa-exclamation-triangle"></i> ');
        $(this).parent().find('input, select, textarea').click(function () {
            $(this).parent().addClass('clicked');
        });
    });
}

function formValidation() {
    $('form.js-izon-validate').attr('novalidate', '1');

    $(document).on('submit', 'form.js-izon-validate', function () {
        var isValid = true;

        $(this).find(':input')
            .each(function () {

                $(this).parent('label[class*="form__item--"]')
                    .removeClass('clicked')
                    .removeClass('error')
                    .find('.message')
                    .remove();

                if ($(this).is(':invalid')) {
                    $(this)
                        .click(function () {
                            $(this).parent().addClass('clicked');
                        })
                        .parent('label[class*="form__item--"]')
                        .addClass('error')
                        .append('<div class="message"><i class="fas fa-exclamation-triangle"></i> Pole je povinné</div>');

                    if (isValid) {
                        if ($(this).closest('.ears__content')) {
                            var currentTab = $(this).closest('.ears__content').attr('data-tab');
                            $('.ears__tab[data-tab="' + currentTab + '"]').trigger('click');
                        }

                        $([document.documentElement, document.body]).animate({
                            scrollTop: $(this).offset().top - 50
                        }, 500);
                    }

                    isValid = false;
                }
            });

        return isValid;
    });
}
