$(document).ready(function() {

	sliderInit();
	formErrorsInit();

}); 

function sliderInit() {

	$('.slider-range').each(function() {

		var my_min = Number($(this).attr('min'));
		var my_max = Number($(this).attr('max'));
		var my_step = Number($(this).attr('step'));
		var my_unit = $(this).attr('unit');
		var my_input = $(this).attr('for');

		$('#'+my_input).val((my_min+my_step) + ' ' + my_unit + ' - ' + (my_max-my_step) + ' ' + my_unit);

		$(this).slider({
			range: true,
			min: my_min,
			max: my_max,
			step: my_step,
			values: [my_min+my_step, my_max-my_step],
		    slide: function( event, ui ) {
				$('#'+my_input).val(ui.values[0] + ' ' + my_unit + ' - ' + ui.values[1] + ' ' + my_unit);
		    }
		});
	});

}

function formErrorsInit() {
	$('form .error .message').each(function() {
		$(this).prepend('<i class="fas fa-exclamation-triangle"></i> ');
		$(this).parent().find('input, select, textarea').click(function() {
			$(this).parent().addClass('clicked');
		});
	});
}
