$(document).ready(function() {

	$('.nav .nav__item--superuser').first().addClass('top-bordered');

	$('.js-filter-switcher').click(function(){
		$(this).closest('.filter').toggleClass('displayed');
	});

//--- OLD------------------


	handleConfirmationPopUp();

	handleTableFilterDisplaying();
	handleFormFilterDisplaying();

	handleCheckboxesInTable();

	//handleTree();

	handleHideRoletkaOnFocusLost();

	handleRemoveRemoveableFormItem();

	handleDateTimePickers();
	handleDatePickers();

	handleSliders();

	handleNewsCheckboxes();
	if($('.nav ul').height() > $(window).height()){
		$('.page__container').css('min-height',$('.nav ul').height() + 65); // bulharska konstanta
	}

}); 

function handleSliders() {
	$('.form__item__slider').each(function() {
		var myrange = 'min';
		var mystep = 25;
		var myvalue = 0;
		var mymax = 100;
		var mymin = 42;

		var input = $(this).parent().find('input');

		if(Number(input.attr('value')) != myvalue) myvalue = Number(input.attr('value'));
		if(Number(input.attr('step')) != mystep) mystep = Number(input.attr('step'));
		if(Number(input.attr('min')) != mymin) mymin = Number(input.attr('min'));
		if(Number(input.attr('max')) != mymax) mymax = Number(input.attr('max'));

		console.log(input.attr('value'));

		$(this).slider({
			range	: myrange,
			step 	: mystep,
			value	: myvalue,
			max		: mymax,
			min 	: mymin,
			slide	: function(e, ui) {
				$(this).parent().find('input').val(ui.value);
			}
		});

		input.change(function() {
			$(this).parent().parent().find('.form__item__slider').slider('value', $(this).val());
		});
	});
}


// Obsluha potvrzovacího popup okna před úplným vymazáním
function handleConfirmationPopUp(){
	$('.fce--delete, table .btn--delete').on('click', function(e) {
		e.preventDefault();
		var link = $(this).attr('href');
		var zaznam = $(this).attr('rel');
		$('.popup #do').attr('href',link);

		$('.popup').fadeIn();
		$('.popup .zaznam').text(zaznam);
	});
	$('.popup .popup__message .close, .popup--form .popup__content .close').on('click', function(e) {
		e.preventDefault();
		$('.popup').fadeOut();
		console.log('fadeOUT 1');
		$('body').removeClass('overlayered');
	});
	$('.popup .popup__message #back, .popup--form .popup__content #back').on('click', function(e) {
		e.preventDefault();
		$('.popup').fadeOut();
		console.log('fadeOUT 2');
		$('body').removeClass('overlayered');
	});
}

function handleTableFilterDisplaying() {
	$('.table--filtered .filterable .filterable__btn').on('click', function() {
		$(this).parent().toggleClass('filtering');
	});
}

function handleFormFilterDisplaying() {
	$('.header__filter-button').on('click', function() {
		$(this).toggleClass('active');
		$('form.form--filter').toggleClass('active');
	});
}


function handleCheckboxesInTable() {
	$('table td.checkbox label[for^=checkbox]').on('click', function() {
		$(this).parent().parent().toggleClass('highlighted');
	});
}

function showPopUp(ident) {
	$('.roletka').hide();
	$('.roletka--tickets').hide();
	$(ident).fadeIn().css('display', 'block');
	$(ident).find('.close, .js-close').on('click', function() {
		$(ident).hide();
	});
    $('body').addClass('overlayered');
}

function appendFormItem(ident) {
	$(ident).clone().removeAttr('id').removeClass('alone').addClass('removeable').insertAfter($(ident).parent().find('.clone').last());
	$(ident).parent().find('.clone').last().prev().addClass('alone');
	$(ident).parent().find('.clone').last().find('input').val('');
	handleRemoveRemoveableFormItem();
}

function handleRemoveRemoveableFormItem() {
	$('.remove-removeable-form-item').on('click', function() {
		if(!$(this).hasClass('alone')) {
			$(this).parent().parent().find('.clone').last().prev().removeClass('alone');
		}
		$(this).parent().remove();
	});
}

function handleKeyboardOnRoletka(roletka){
  //console.log('keys')
  $(document).off('keydown'); // vypnuti jinych sledovacu klavesnice (jinych roletek)
  roletka = $(roletka);
  $('.roletka, .roletka--tickets').not(roletka).hide();

  roletka.find('.roletka__line').first().addClass('focused').addClass('first');
  roletka.find('.roletka__line').last().addClass('last');



  $(document).keydown(function(e) {
    switch(e.which) {
      case 40: //down
        var focused = roletka.find('.focused');
        if (!focused.hasClass('last')) {
          focused.removeClass('focused').next().addClass('focused');
        }
        break;
      case 38: //up
        var focused = roletka.find('.focused');
        if (!focused.hasClass('first')) {
          focused.removeClass('focused').prev().addClass('focused');
        }
        break;
      case 13: //enter
        roletka.find('.focused').trigger('click');
        $(document).off('keydown');
        break;
      default: 
        roletka.parent().find('input').focus();
        //isAlreadyHandlingKeysOnRoletka = false;
        $(document).off('keydown');
        return;
    }
    e.preventDefault();
  });
}

function handleHideRoletkaOnFocusLost() {
  // schování roletek při ztrátě focusu inputu
	$('input').focusout(function(elem) {
		setTimeout(function() {
			console.log('hide-rol');
			$('.roletka, .roletka--tickets').hide();
  			$(document).off('keydown'); // vypnuti jinych sledovacu klavesnice (jinych roletek)
		}, 200);
	});	
}

function handleDateTimePickers() {
	$('input.datetimepicker').each(function() {
		handleDateTimePicker($(this));
	});
}

function handleDateTimePicker($input) {
var myControl=  
	$input.datetimepicker({
		controlType: 	{
			create: function(tp_inst, obj, unit, val, min, max, step){
				$('<input class="ui-timepicker-input" value="'+val+'">')
					.appendTo(obj)
					.spinner({
						min: min,
						max: max,
						step: step,
						change: function(e,ui){ // key events
								// don't call if api was used and not key press
								if(e.originalEvent !== undefined)
									tp_inst._onTimeChange();
								tp_inst._onSelectHandler();
							},
						spin: function(e,ui){ // spin events
								tp_inst.control.value(tp_inst, obj, unit, ui.value);
								tp_inst._onTimeChange();
								tp_inst._onSelectHandler();
							}
					});
				return obj;
			},
			options: function(tp_inst, obj, unit, opts, val){
				if(typeof(opts) == 'string' && val !== undefined)
					return obj.find('.ui-timepicker-input').spinner(opts, val);
				return obj.find('.ui-timepicker-input').spinner(opts);
			},
			value: function(tp_inst, obj, unit, val){
				if(val !== undefined)
					return obj.find('.ui-timepicker-input').spinner('value', val);
				return obj.find('.ui-timepicker-input').spinner('value');
			}
		},
		timeFormat: 	'HH:mm',
		dateFormat: 	'd.m.yy',
		showTime: 		false,
		hourText: 		'Čas',
		minuteText:		''
	});
}


function handleNewsCheckboxes() {
	if($('.news-checkbox__val').length > 0) {
		$('.news-checkbox__val').each(function() {
			$(this).parent().find('.form__item__caption--checkbox').text($(this).text());
		});
	}
}

function handleDatePickers() {
	$('input.datepicker').each(function() {
		handleDatePicker($(this));
	});
}

function handleDatePicker($input){
		$input.datepicker({
			dateFormat: "d.m.yy"
		});
}