/**
 *
 *  Základní tasky pro vývoj projektu:
 *  ----------------------------------
 *  "gulp watch"      - sleduje změny v </static/assest/> a spouští podle tyou souboru js:dev, sass:dev, svgstore nebo sprite tasky
 *  "gulp sync"       - stejné jako watch plus spouští "browsersync" pro spuštění serveru na localhostu (defaultně na portu 3000) pro lazení na mobilech/tabletech
 *  "gulp build"      - spouští se před nasazením projektu, tasky (js:build, sass:build, clean-maps), minifikuje CSS, JS a maže sourcemaps
 *
 *
 *  Dílčí tasky (většinou obsazeny v tascích nahoře a není je potřeba spouštět samostatně
 *  -------------------------------------------------------------------------------------
 *
 *  "gulp js:dev"     - spojuje javascripty v assets/js/, vytváří sourcemaps
 *  "gulp js:build"   - spojuje javascripty v assets/js/, minifikuje, maže sourcemaps
 *
 *  "gulp sass:dev"   - spojuje sassy v assets/sass/, vytváří sourcemaps
 *  "gulp sass:build" - spojuje sassy v assets/sass/, minifikuje, maže sourcemaps
 *
 *  "gulp svgstore"   - veme všechny SVG z /assest/svg/defs/, udělá jedno defs.svg, které se skryté načítá v záhlaví stránky (typicky v basic-layout.lay.php)
 *
 *    použití takovýchto SVG je pak:
 *
 *    <svg class="tridy jake chces">
        <use xlink:href="#nazev-souboru"></use>
      </svg>
 *
 *  "gulp:sprite"     - veme všechny PNG v /assets/sprites/, a udělá z nich PNG sprite, použití spritů je popsáno v "/assets/sass/core/_sprites.scss"
 *                    - ! pozor je nastaveno i na vytváření PNG pro retina displeje, PNGčka je potřeba vytvořit 2x v podobě: "soubor.png" + "soubor@2x.png"
 *                    *
 *
 *  Speciální tasky
 *  -------------------------------------------------------------------------------------
 *
 *  gulp modernizr    - projede javascripty v assets/js/ a vytvoří custom build modernizeru pro nalezené testy
 *
 *
 */



 'use strict';


 var gulp = require('gulp');
 var sass = require('gulp-sass');
 var sourcemaps = require('gulp-sourcemaps');
 var spritesmith = require('gulp.spritesmith');
 var autoprefixer = require("gulp-autoprefixer");
 var uglify = require("gulp-uglify");
 var concat = require("gulp-concat");
 var livereload = require('gulp-livereload');
 var notify = require('gulp-notify');
 var sassGlob = require('gulp-sass-glob');
 var clean = require('gulp-clean');
 var watch = require('gulp-watch');
 var svgstore = require('gulp-svgstore');
 var svgmin = require('gulp-svgmin');
 var path = require('path');
 var plumber = require('gulp-plumber');
 var browserSync = require('browser-sync').create();
 var modernizr = require('gulp-modernizr');


 var src = "./assets/";
 var dest = "../www/";
 var project = 'eldorado-2018';
 var dest_project = "../../"+ project + "/htdocs/vendor/izon/admin-styles/www/";
 //var dest_project = "../../clovekvtisni-2018/libs/admin/www/";


 gulp.task('sass:dev', function () {
  gulp.src(src + 'sass/style.scss')
  .pipe(sassGlob())
  .pipe(sourcemaps.init())
  .pipe(sass())
  .on('error', swallowError)
  .pipe(autoprefixer({browsers: ['last 6 versions'], cascade: true}))
  .pipe(sourcemaps.write('./maps'))
  .pipe(gulp.dest( dest + 'css/'))
  .pipe(gulp.dest( dest_project + 'css/'));
});

 gulp.task('sass:build', function () {

  gulp.src(src + 'sass/style.scss')
  .pipe(sassGlob())
  .pipe(sass({outputStyle: 'compressed'}))
  .on('error', swallowError)
  .pipe(autoprefixer({browsers: ['last 6 versions'], cascade: false}))
  .pipe(gulp.dest( dest + 'css/'))
  .pipe(gulp.dest( dest_project + 'css/'));


});



 gulp.task('svgstore', function () {
  return gulp
  .src(src + 'svg/defs/*.svg')
  .pipe(svgmin(function (file) {
    return {
      plugins: [{
      }]
    }
  }))
  .pipe(svgstore({ inlineSvg: true }))
  .pipe(gulp.dest(dest + 'images/svg/'))
  .pipe(gulp.dest(dest_project + 'images/svg/'));
});


 gulp.task('sprite', function () {
  var spriteData = gulp.src('assets/sprites/*.png').pipe(spritesmith({
    imgName: 'sprite.png',
    cssName: '_sprites.scss',
    imgPath: '../images/sprite.png',
    retinaSrcFilter: ['assets/sprites/*@2x.png'],
    retinaImgPath: '../images/sprite@2x.png',
    retinaImgName: 'sprite@2x.png'
  }));

  spriteData.img.pipe(gulp.dest(dest + 'images/'));
  spriteData.img.pipe(gulp.dest(dest_project + 'images/'));
  spriteData.css.pipe(gulp.dest(src + 'sass/core/'));


});


 gulp.task('modernizr', function() {
  gulp.src(src + '/js/*.js')
  .pipe(modernizr({
    "crawl": false,
    "customTests": [],
    "tests": [],
    "options": [
    "setClasses"
    ],
    "uglify": false
  }))
  .pipe(gulp.dest(src + '/js/vendor/'))
});

// seznam načítaných JS, využije se pak ve variantě s uglify i bez
var javascripts = [
 //'node_modules/jquery/dist/jquery.min.js',
 src + '/js/vendor/**/*.js',
 src + '/js/*.js'
 ];


 gulp.task('js:dev', function () {
   return gulp.src(
    javascripts)
   .pipe(sourcemaps.init({loadMaps: true}))
   .pipe(concat('app.js'))
   .pipe(gulp.dest(dest + 'js/'))
   .pipe(gulp.dest(dest_project + 'js/'))
   .pipe(sourcemaps.write(dest + 'js/'))
   .pipe(sourcemaps.write(dest_project + 'js/'))
   .pipe(livereload());
 });

 gulp.task('js:build', function () {
   return gulp.src(
    javascripts)
   .pipe(uglify())
   .pipe(concat('app.js'))
   .pipe(gulp.dest(dest + 'js/'))
   .pipe(gulp.dest(dest_project + 'js/'));
 }).on('error', swallowError);

 gulp.task('watch', function() {


   livereload.listen();

   watch('assets/sass/**/*.scss', function(files) {
    gulp.start('sass:dev');
  });

//   watch(dest + '/css/**/*.css', function(files) {
//    livereload.changed(dest + 'css/style.css');
//  });

   watch(dest_project + 'css/**/*.css', function(files) {
    livereload.changed(dest_project + 'css/style.css');
  });


   watch(src + '/svg/defs/*.svg', function(files) {
    gulp.start('svgstore');
    livereload.reload();
  });


   watch(src + '/sprites/*.png', function(files) {
    gulp.start('sprite');
    livereload.reload();
  });


   watch('assets/js/*.js', function() {
    gulp.start('js:dev');
    livereload.reload();
  });



   watch([dest + 'templates/*.*',  dest + 'js/**/*.js', '../htdocs/views/**/*.php'],  function(){
    livereload.reload();
  });
   watch([dest_project + 'templates/*.*',  dest_project + 'js/**/*.js', '../htdocs/views/**/*.php'],  function(){
    livereload.reload();
  });

 });


 gulp.task('sync', function () {

   gulp.start('watch');

   browserSync.init({
    proxy: 'http://plastia-2017.izon.localhost/',
    port: 3000,
    files: dest + 'css/style.css'
  });


 });



 gulp.task('clean-maps', function(){
  return gulp.src([dest + 'css/maps/'], {read:false})
  .pipe(clean({force:true}));
});





 gulp.task('build', ['sass:build', 'js:build', 'clean-maps']);

// řeší ukončení watch tasku při scss chybě
function swallowError (error) {
  var args = Array.prototype.slice.call(arguments);
  notify.onError({
    title: 'Compile Error',
    message: '<%= error.message %>'
  }).apply(this, args);
  this.emit('end'); // Keep gulp from hanging on this task
}