<?php

namespace IZON\Modules\StyleGuide\Admin\Forms;

use IZON\Forms\Form;

/**
 * factory pro vytvareni formularu
 */
class AdminFormFactory {
    
    public static function createForm() {
        
        $form = new Form();
        
        $form->addIdField('id', __('Id'));
        $form->addCharField('charField', __('input text'));
        $form->addTextField('textField', __('textarea'));
        $form->addEmailField('email', __('email'));
        $form->addCheckboxField('checkbox', __('checkbox'));
        $form->addDateFiled('datefield', __('input date'));
        $form->addFileField('filefield', __('input file'));
        $form->addFloatField('floatfield', __('input float'));
        $form->addHiddenField('hidden', __('input hidden'));
        $form->addImageField('image', __('input image'));
        $form->addIntegerField('intfiled', __('input integer'));
        $form->addPasswordField('passwdfiled', __('input passwd'));
        $form->addPhoneField('phonedfiled', __('input phone'));
        $form->addRadioListField('radiodfiled', __('input radio'))->setOptions(['a' => 'prvni', 'b' => 'druhy']);

        $form->addCheckboxListField('checkboxListFiled', __('input CheckboxList'))
            ->setOptions(
                ['a' => 'prvni', 'b' => 'druhy'],
                function($emement, $index) { return ["key" => $index, "label" => $emement]; }
            );
        $form->addSelectField('selectbox', __('selectbox'))
            ->setOptions(
                [
                    ["key" => 'a', 'label' => 'prvni'],
                    ["key" =>'b', 'label' => 'druhy']
                ]
            );
        
        return $form;
    }
}
