<?php
// soucasny modul
  $thisModule = \PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);

  $editURL = \AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "edit", [], $thisModule->getIdentifier());
  /*@var $form IZON\Forms\Form*/
  $form       = \PHPView\getParameter("form");

?>

<pre>
<h2>Nadpis</h2>
Pokud chci vypsat nadpis s názvem modulu, volám fci bez parametru.
Název modulu je nadpisem hlavní zobrazené stránky - většinou list view.
<code>&lt;?php
  \AdminPHPView\renderModuleTitle('Nadpis');
?&gt;
</code>
</pre>
<?php
  \AdminPHPView\renderModuleTitle('Nadpis'); // is wrapped into col-xs-12 and h1
?>

<div class="separator"></div>

<pre>
<h2>Separátor</h2>
Pro oddělení čarou:
<code>&lt;div class="separator"&gt;&lt;/div&gt;
</code>
Pro nový řádek v bootstrap-gridu:
<code>&lt;div class="clearfix"&gt;&lt;/div&gt;
</code>
</pre>

<div class="separator"></div>


<pre>
<h2>Filtr</h2> 
- u výpisu (například)
- Pokud chci, aby byl fitr na začátku zobrazený, dám mu třídu <i>displayed</i>, jinak nedávám.
- Dodržuj pojmenování tlačítek - infinititv (pozn.: Vyčistit filtr můžeš u auta, tady se ruší nastavení).
<code>&lt;section class="col-xs-12"&gt;
  &lt;div class="form-container filter displayed"&gt;
    &lt;span class="btn form-container__btn--ear--right js-filter-switcher"&gt;
      &lt;span class="turn-off-text"&gt;&lt;i class="fas fa-eye-slash"&gt;&lt;/i&gt;&lt;?=__('Schovat filtr')?&gt;&lt;/span&gt;
      &lt;span class="turn-on-text"&gt;&lt;i class="fas fa-eye"&gt;&lt;/i&gt;&lt;?=__('Zobrazit filtr')?&gt;&lt;/span&gt;
    &lt;/span&gt;
    &lt;form id="dynamic-table-filter" method="get" class="form <?= $filterActive ?>">
      &lt;input type="hidden" name="setFilter" value="1"&gt;
      &lt;div class="col-xs-12 col-md-6"&gt;
        &lt;?= \IZON\Admin\Forms\getAdminField($filterForm, 'name', ['field' => ["attributes" => ["onclick" => "dynamicTable.dynamicTable('reloadFilterForm')", "onkeyup" => "dynamicTable.dynamicTable('reloadFilterForm')"]]])  ?&gt;
      &lt;/div&gt;
      &lt;div class="col-xs-12 col-md-2"&gt;
        &lt;?= \IZON\Admin\Forms\getAdminField($filterForm, 'active', ['field' => ["attributes" => [ "onchange" => "dynamicTable.dynamicTable('reloadFilterForm')"]]]) ?&gt;
      &lt;/div&gt;
      &lt;div class="col-xs-12 col-md-4" style="padding-top: 1.3rem;"&gt;
        &lt;button style="margin: 0.5rem;" name="button" class="btn btn--small btn--mint icon--filter"&gt;&lt;?= __('Filtrovat') ?&gt;&lt;/button&gt;
        &lt;a style="margin: 0.5rem;" href="&lt;?= $clearFilterURL ?>" class="btn btn--small btn--gray icon--times"&gt;&lt;?= __('Zrušit nastavení') ?&gt;&lt;/a&gt;
      &lt;/div&gt;
    &lt;/form&gt;
  &lt;/div&gt;
&lt;/section&gt;
</code>
</pre>
<div style="height: 3rem"></div>
<section class="col-xs-12">
  <div class="form-container filter displayed">
    <span class="btn form-container__btn--ear--right js-filter-switcher">
      <span class="turn-off-text"><i class="fas fa-eye-slash"></i><?=__('Schovat filtr')?></span>
      <span class="turn-on-text"><i class="fas fa-eye"></i><?=__('Zobrazit filtr')?></span>
    </span>
    <form id="dynamic-table-filter" method="get" class="form <?= $filterActive ?>">
      <input type="hidden" name="setFilter" value="1">
      <div class="col-xs-12 col-md-6">
        <label class="form__item--text">
          <span class="form__item__caption--text">Title</span>
          <input type="text" class="form__item__field--text">
        </label>
      </div>
      <div class="col-xs-12 col-md-2">
        <label class="form__item--text">
          <span class="form__item__caption--text">Title</span>
          <input type="text" class="form__item__field--text">
        </label>
      </div>
      <div class="col-xs-12 col-md-4" style="padding-top: 1.3rem;">
        <button style="margin: 0.5rem;" name="button" class="btn btn--small btn--mint"><i class="fas fa-filter"></i><?= __('Filtrovat') ?></button>
        <a style="margin: 0.5rem;" href="<?= $clearFilterURL ?>" class="btn btn--small btn--gray"><i class="fas fa-times"></i><?= __('Zrušit nastavení') ?></a>
      </div>
    </form>
  </div> <!-- .container -->
</section>


<div class="separator"></div>

<pre>
<h2>Buttony</h2>
Mohou mít libovolný tag (a, span, div, button)
Input jako button nepoužíváme!
Textaci pokud možno volíme v infinitivu.
<code>&lt;button class="btn btn--mint"&gt;&lt;i class="fas fa-plus"&gt;&lt;/i&gt;&lt;?=_('Přidat')?&gt;&lt;/button&gt;
&lt;button class="btn btn--gray"&gt;&lt;i class="fas fa-envelope"&gt;&lt;/i&gt;&lt;?=_('Odeslat')?&gt;&lt;/button&gt;
&lt;button class="btn btn--mint btn--small"&gt;&lt;i class="fas fa-check"&gt;&lt;/i&gt;&lt;?=_('OK')?&gt;&lt;/button&gt;
&lt;button class="btn btn--gray btn--big"&gt;&lt;i class="fas fa-times"&gt;&lt;/i&gt;&lt;?=_('Odstranit')?&gt;&lt;/button&gt;
</code>
</pre>
<button class="btn btn--mint"><i class="fas fa-plus"></i><?=_('Přidat')?></button>
<button class="btn btn--gray"><i class="fas fa-envelope"></i><?=_('Odeslat')?></button>
<button class="btn btn--mint btn--small"><i class="fas fa-check"></i><?=_('OK')?></button>
<button class="btn btn--gray btn--big"><i class="fas fa-times"></i><?=_('Odstranit')?></button>


<div class="separator"></div>

<pre>
<h2>Tabulka</h2>
Každá tabulka musí mít ošetřený stav při nahrávání!
Každá tabulka musí mít ošetřený stav nebylo-li nic nalezeno!
Tabluka má nastavene na některé sloupce pevnou šířku, aby nebyly zbytečně široké.
Pokud ve sloupci "Aktivní" nelze překlikávat, buňka bude mít třídu <i>informative</i>.
Ikony, které jsou v tabulce použity musí být definovány před tabulkou a v tabulce se následně používají pomocí <i>svg use</i>, do parametru xilink:href pak vložíme parametr z definice data-fa-symbol.
Pokud je ve funcích fce pro smazání záznamu, odkaz ponese třídu <i>js-delete-record</i>, která zajistí zobrazení dotazovacího popupu před reálným smazáním (popup a fčnost zajišťuje app.js).
<code>&lt;section class="col-xs-12" style="margin-top: 2rem"&gt;
  &lt;div class="table-icons" style="display: none;"&gt;
    &lt;i class="fas fa-check" data-fa-symbol="icon--true"&gt;&lt;/i&gt;
    &lt;i class="fas fa-times" data-fa-symbol="icon--false"&gt;&lt;/i&gt;
    &lt;i class="fas fa-edit" data-fa-symbol="icon--edit"&gt;&lt;/i&gt;
  &lt;/div&gt;
  &lt;table id="dynamic-table" class="table--dynamic"&gt;
    &lt;thead&gt;
      &lt;tr&gt;
        &lt;th class="sortable sorted--asc" data-property-name="id" style="width: 9rem;"&gt;&lt;?= __('#') ?>&lt;/th&gt;
        &lt;th class="sortable sorted--asc" data-property-name="name" style="text-align: left;"&gt;&lt;?= __('Název') ?>&lt;/th&gt;
        &lt;th class="sortable sorted--asc" data-property-name="active" style="width: 9rem;"&gt;&lt;?= __('Aktivní') ?>&lt;/th&gt;
        &lt;th style="width: 9rem;"&gt;&lt;?=__('Funkce')?>&lt;/th&gt;
      &lt;/tr&gt;
    &lt;/thead&gt;
    &lt;tbody&gt;
      &lt;tr&gt;&lt;td class="table__note--searching" colspan="4"&gt;&lt;?=__('Vykresluji obsah tabulky')?&gt;&lt;/td&gt;&lt;/tr&gt;
      &lt;?php /* Zde se vypisuje obsah tabulky, který následně nahradí také spinner */ ?>
    &lt;/tbody&gt;
  &lt;/table&gt;
&lt;/section&gt;
</code>
<h3>Příklad jednoho řádku tabulky (PHP část):</h3>
<code>$object = [
    'id' => $obj->getId(),
    'name' => $obj->getProductName(),
    'active' => ($obj->getActive() ? '&lt;svg class="true svg-inline--fa fa-w-20"&gt;&lt;use xlink:href="#icon--true"&gt;&lt;/use>&lt;/svg&gt;' : '&lt;svg class="false svg-inline--fa fa-w-20"&gt;&lt;use xlink:href="#icon--false"&gt;&lt;/use&gt;&lt;/svg&gt;'),
    'editURL' => $editURL,
    'editText' => __('Editovat'),
];
</code>
<h3>Příklad (JS část):</h3>
<code>
&lt;script type="text/javascript">
    var dynamicTable = null;
    $(document).ready(function () {
        dynamicTable = $("#dynamic-table").dynamicTable({
            getCurrentPageURL: '&lt;?= $currentPageURL ?>',
            changeTableSortingURL: '&lt;?= $changeTableSortingURL ?>',
            setFilterURL: '&lt;?= $setFilterURL ?>',
            clearFilterURL: '&lt;?= $setFilterURL ?>',
            switchPageURL: '&lt;?= $switchPageURL ?>',

            pageSwitchers: $(".page-switcher"),

            noRowsFoundMessage: "&lt;?= __('Nebyl nalezen žádný záznam.')?>",
            loadingMessage: "&lt;?= __('Vykresluji obsah tabulky')?>",

            rowRenderer: function (obj) {
                //console.log(obj);
                var row = "&lt;tr>";
                row += '&lt;td>' + obj.id + '</td>';
                row += '&lt;td>&lt;a href="' + obj.editURL + '">' + obj.name + '&lt;/a>&lt;/td>';
                row += '&lt;td style="text-align: center;" class="imformative">' + obj.active + '&lt;/td>';
                row += '&lt;td style="text-align: center;">&lt;a href="' + obj.editURL + '" title="' + obj.editText + '">&lt;svg class="svg-inline--fa fa-w-20">&lt;use xlink:href="#icon--edit">&lt;/use>&lt;/svg>&lt;/a>';
                row += '&lt;/td>';
                row += "&lt;/tr>";
                return row;
            }
        });
    });
&lt;/script>
</code>

</pre>

  <div class="table-icons" style="display: none;">
    <i class="fas fa-check" data-fa-symbol="icon--true"></i>
    <i class="fas fa-times" data-fa-symbol="icon--false"></i>
    <i class="fas fa-edit" data-fa-symbol="icon--edit"></i>
  </div>
  <table id="dynamic-table" class="table--dynamic">
    <thead>
      <tr>
        <th class="sortable sorted--desc" data-property-name="id" style="width: 9rem;">#<span class="sortable__down"></span><span class="sortable__up"></span></th>
        <th class="sortable" data-property-name="name" style="text-align: left;">Název<span class="sortable__down"></span><span class="sortable__up"></span></th>
        <th class="sortable" data-property-name="active" style="width: 9rem;">Aktivní<span class="sortable__down"></span><span class="sortable__up"></span></th>
        <th style="width: 9rem;">Funkce</th>
      </tr>
    </thead>
    <tbody>
      <tr><td colspan="4"><span class="table__note--searching"><i class="fas fa-spinner fa-pulse"></i>Vykresluji obsah tabulky</span></td></tr>
    </tbody>
  </table>

  <table id="dynamic-table" class="table--dynamic">
    <thead>
      <tr>
        <th class="sortable sorted--desc" data-property-name="id" style="width: 9rem;">#<span class="sortable__down"></span><span class="sortable__up"></span></th>
        <th class="sortable" data-property-name="name" style="text-align: left;">Název<span class="sortable__down"></span><span class="sortable__up"></span></th>
        <th class="sortable" data-property-name="active" style="width: 9rem;">Aktivní<span class="sortable__down"></span><span class="sortable__up"></span></th>
        <th style="width: 9rem;">Funkce</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>29645</td>
        <td>
          <a href="">Pěstební nádoba Urbalive hnědá</a>
        </td>
        <td style="text-align: center;" class="informative">
          <svg class="svg-inline--fa fa-w-20 true"><use xlink:href="#icon--true"></use></svg>
        </td>
        <td style="text-align: center;">
          <a href="" title="Editovat"><svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--edit"></use></svg></a>
        </td>
      </tr>
      <tr>
        <td>29646</td>
        <td>
          <a href="">Pěstební nádoba Urbalive žlutá</a>
        </td>
        <td style="text-align: center;" class="informative">
          <svg class="svg-inline--fa fa-w-20 false"><use xlink:href="#icon--false"></use></svg>
        </td>
        <td style="text-align: center;">
          <a href="" title="Editovat"><svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--edit"></use></svg></a>
        </td>
      </tr>
    </tbody>
  </table>

  <table id="dynamic-table" class="table--dynamic">
    <thead>
      <tr>
        <th class="sortable sorted--desc" data-property-name="id" style="width: 9rem;">#<span class="sortable__down"></span><span class="sortable__up"></span></th>
        <th class="sortable" data-property-name="name" style="text-align: left;">Název<span class="sortable__down"></span><span class="sortable__up"></span></th>
        <th class="sortable" data-property-name="active" style="width: 9rem;">Aktivní<span class="sortable__down"></span><span class="sortable__up"></span></th>
        <th style="width: 9rem;">Funkce</th>
      </tr>
    </thead>
    <tbody>
      <tr><td colspan="4"><span class="table__note"><i class="fas fa-info-circle"></i>Obsah pro vykreslení nebyl nalezen</span></td></tr>
    </tbody>
  </table>





<div class="separator"></div>

<pre>
<h2>Poznámky</h2>
Poznámky můžeme používat kdekoli ve view - tedy tyto poznámky mohou být využity například ihned pod nadpisem, nebo v části s formulářovým prvkem (uvnitř divu s bootstrap-grid třídou). Zároveň, pokud bude potřeba, můžeme ovlivnit jejich margin pomocí inline stylů.
<code>&lt;div class="note">&lt;i class="fas fa-info-circle">&lt;/i> Informační poznámka&lt;/div>
&lt;div class="note--error">&lt;i class="fas fa-exclamation-circle">&lt;/i> Error poznámka&lt;/div>
</code>
</pre>

<div class="note"><i class="fas fa-info-circle"></i> Informační poznámka</div>
<div class="note--error"><i class="fas fa-exclamation-circle"></i> Informační poznámka</div>

<div class="separator"></div>


<pre>
<h2>Ikony</h2>
Vycházíme z: <a target="_blank" href="http://fontawesome.io/icons/">Font Awesome</a>
Prvek nesoucí ikonu (button, ikona v tabulce, položka v menu a podobně) bude uvnitř obsahovat prvek <i>&lt;i&gt;</i>, který lze nalézt na stránkách FontAwesome.
Např: <i>&lt;i class="fab fa-angellist">&lt;/i></i>
Například jako <strong>buttony</strong> výše.
</pre>


<div class="separator"></div>

<pre>
<h2>Ouška (Ears, Taby)</h2>
<code>&lt;div class="ears">
  &lt;div class="ears__tabs">
    &lt;div class="ears__tab" data-tab="tab-1">Tab 1&lt;/div>
    &lt;div class="ears__tab" data-tab="tab-2">Tab 2&lt;/div>
  &lt;/div>
  &lt;div class="ears__contents">
    &lt;div class="ears__content" data-tab="tab-1">
      Já jsem obsah tabu č. 1.
    &lt;/div>
    &lt;div class="ears__content" data-tab="tab-2">
      Já jsem obsah tabu č. 1.
    &lt;/div>
  &lt;/div>
&lt;/div>
</code>
</pre>

<div class="ears">
  <div class="ears__tabs">
    <div class="ears__tab" data-tab="tab-1">Tab 1</div>
    <div class="ears__tab" data-tab="tab-2">Tab 2</div>
    <div class="ears__tab" data-tab="tab-3"><i class="fas fa-plus"></i></div>
  </div>
  <div class="ears__contents">
    <div class="ears__content" data-tab="tab-1">
      Já jsem obsah tabu č. 1.
    </div>
    <div class="ears__content" data-tab="tab-2">
      Já jsem obsah tabu č. 2.
    </div>
    <div class="ears__content" data-tab="tab-3">
      Já jsem obsah tabu pro přidání ...
    </div>
  </div>
</div>

<div class="separator"></div>

<pre>
<h2>Dropzony</h2>
Dropzony jsou si velmi podobné. (V budoucnu snad budou integrované do systému.)
Pokud potřebuješ někde mít input, který si bude pamatovat nějakou hodnotu, vlož si ho kam potřebuješ.
V rámci app.js nejsou Dropzony nijak ovládány.
<h3>Dropzone ONE image</h3>
<code>&lt;div class="dropzone--image">
  &lt;div id="image-upload" class="dropzone__box">
      &lt;span class="dropzone__box__message">&lt;i class="fas fa-image">&lt;/i>&lt;?= __('Přetažením nebo kliknutím nahrajte obrázek') ?>&lt;/span>
  &lt;/div>
&lt;/div>
</code>
<h3>Dropzone ONE file</h3>
<code>&lt;div class="dropzone--file">
  &lt;div id="file-upload" class="dropzone__box">
      &lt;span class="dropzone__box__message">&lt;i class="fas fa-file">&lt;/i>&lt;?= __('Přetažením nebo kliknutím nahrajte soubor') ?>&lt;/span>
  &lt;/div>
&lt;/div>
</code>
<h3>Dropzone images</h3>
<code>&lt;div class="dropzone--images">
  &lt;div id="images-upload" class="dropzone__box">
      &lt;span class="dropzone__box__message">&lt;i class="fas fa-images">&lt;/i>&lt;?= __('Přetažením nebo kliknutím nahrajte obrázky') ?>&lt;/span>
  &lt;/div>
  &lt;ul id="images-container" class="dropzone__list">
    &lt;li class="dropzone__list__item">
      &lt;img src="/images/noimage.jpg" >
      &lt;div class="dropzone__list__item__buttons">
        &lt;button class="dropzone__list__item__button" type="button" onclick="getSpecificConfig(imagesDropzone).removeDropzoneRow(this.parentNode.parentNode);">
          &lt;i class="fas fa-times">&lt;/i>
        &lt;/button>
        &lt;button class="dropzone__list__item__button" type="button" onclick="getSpecificConfig(imagesDropzone).turnDropzoneImageLeft(this.parentNode.parentNode);">
          &lt;i class="fas fa-undo">&lt;/i>
        &lt;/button>
        &lt;button class="dropzone__list__item__button" type="button" onclick="getSpecificConfig(imagesDropzone).turnDropzoneImageRight(this.parentNode.parentNode);">
          &lt;i class="fas fa-redo">&lt;/i>
        &lt;/button>
      &lt;/div>
      <i>... Prostor pro formulář - popisek atd ...</i>
    &lt;/li>
  &lt;/ul>
&lt;/div>
</code>
<h3>Dropzone files</h3>
<code>&lt;div class="dropzone--files">
  &lt;div id="files-upload" class="dropzone__box">
    &lt;span class="dropzone__box__message">&lt;i class="fas fa-file">&lt;/i>&lt;?= __('Přetažením nebo kliknutím nahrajte soubory') ?>&lt;/span>
  &lt;/div>
  &lt;ul id="files-container" class="dropzone__list">
    &lt;li class="dropzone__list__item">
      &lt;span class="dropzone__list__item__filename">
        &lt;i class="fas fa-file-pdf">&lt;/i>
        Filename.pdf
      &lt;/span>
      <i>... Prostor pro formulář - popisek atd ...</i>
    &lt;/li>
  &lt;/ul>
&lt;/div>
</code>
</pre>
<div class="row">
  <div class="col-xs-12 col-sm-2">

    <div class="dropzone--image">
        <div id="image-upload" class="dropzone__box">
            <span class="dropzone__box__message"><i class="fas fa-image"></i><?= __('Přetažením nebo kliknutím nahrajte obrázek') ?></span>
        </div>
    </div>
    
  </div>
  <div class="col-xs-12 col-sm-2">

    <div class="dropzone--file">
        <div id="file-upload" class="dropzone__box">
            <span class="dropzone__box__message"><i class="fas fa-file"></i><?= __('Přetažením nebo kliknutím nahrajte soubor') ?></span>
        </div>
    </div>

  </div>
  <div class="col-xs-12 col-sm-4">

    <div class="dropzone--images">
        <div id="images-upload" class="dropzone__box">
            <span class="dropzone__box__message"><i class="fas fa-images"></i><?= __('Přetažením nebo kliknutím nahrajte obrázky') ?></span>
        </div>
        <ul id="images-container" class="dropzone__list">
          <li class="dropzone__list__item">
            <img src="/images/noimage.jpg" >
            <div class="dropzone__list__item__buttons">
              <button class="dropzone__list__item__button" type="button" onclick="getSpecificConfig(imagesDropzone).removeDropzoneRow(this.parentNode.parentNode);">
                <i class="fas fa-times"></i>
              </button>
              <button class="dropzone__list__item__button" type="button" onclick="getSpecificConfig(imagesDropzone).turnDropzoneImageLeft(this.parentNode.parentNode);">
                <i class="fas fa-undo"></i>
              </button>
              <button class="dropzone__list__item__button" type="button" onclick="getSpecificConfig(imagesDropzone).turnDropzoneImageRight(this.parentNode.parentNode);">
                <i class="fas fa-redo"></i>
              </button>
            </div>
            <div class="col-xs-12">
              <label class="form__item--text"><span class="form__item__caption--text">Popis</span><input type="text" class="form__item__field--text" value="" name="productImage[2106][productImageTranslation][1][name]"></label>
            </div>
          </li>
        </ul>
    </div>

  </div>
  <div class="col-xs-12 col-sm-4">
  
    <div class="dropzone--files">
        <div id="files-upload" class="dropzone__box">
          <span class="dropzone__box__message"><i class="fas fa-file"></i><?= __('Přetažením nebo kliknutím nahrajte soubory') ?></span>
        </div>
        <ul id="files-container" class="dropzone__list">
          <li class="dropzone__list__item">
            <span class="dropzone__list__item__filename">
              <i class="fas fa-file-pdf"></i>
              Filename.pdf
            </span>
            <div class="col-xs-12">
              <label class="form__item--text"><span class="form__item__caption--text">Zobrazovaný název</span><input type="text" class="form__item__field--text" value="" name="productImage[2106][productImageTranslation][1][name]"></label>
            </div>
          </li>
        </ul>
    </div>

  </div>
</div>

<div class="separator"></div>

<pre>
<h2>Struktura (Tree, Strom)</h2>
<code>&lt;ul class="tree full-width">
  &lt;li>
    &lt;div class="tree__leave">
      Hlavní úroveň&nbsp;
      &lt;span style="font-weight: normal; font-size: 10pt">(42)&lt;/span>
      &lt;div class="tree__leave__functions">
        &lt;a href="#" title="&lt;?=__('Vytvořit potomka')?>">&lt;i class="fas fa-plus">&lt;/i>&lt;/a>
        &lt;a href="#" title="&lt;?=__('Editovat')?>">&lt;i class="fas fa-edit">&lt;/i>&lt;/a>
        &lt;a href="#" title="&lt;?=__('Smazat')?>">&lt;i class="fas fa-trash">&lt;/i>&lt;/a>
      &lt;/div>
      &lt;p class="tree__leave__caption">Popis když chceme nějaké vysvětlení ...&lt;/p>
    &lt;/div>
    &lt;ul class="tree full-width">
      &lt;li>
        &lt;div class="tree__leave">
          Potomek
          &lt;span style="font-weight: normal; font-size: 10pt">(3)&lt;/span>
          &lt;div class="tree__leave__functions">
            &lt;a href="#" title="&lt;?=__('Vytvořit potomka')?>">&lt;i class="fas fa-plus">&lt;/i>&lt;/a>
            &lt;a href="#" title="&lt;?=__('Editovat')?>">&lt;i class="fas fa-edit">&lt;/i>&lt;/a>
            &lt;a href="#" title="&lt;?=__('Smazat')?>">&lt;i class="fas fa-trash">&lt;/i>&lt;/a>
          &lt;/div>
          &lt;p class="tree__leave__caption">Popis potomka&lt;/p>
        &lt;/div>
        &lt;ul class="tree full-width">
          &lt;li>
            &lt;div class="tree__leave">
              Potomeček
              &lt;span style="font-weight: normal; font-size: 10pt">(7)&lt;/span>
              &lt;div class="tree__leave__functions">
                &lt;a href="#" title="&lt;?=__('Vytvořit potomka')?>">&lt;i class="fas fa-plus">&lt;/i>&lt;/a>
                &lt;a href="#" title="&lt;?=__('Editovat')?>">&lt;i class="fas fa-edit">&lt;/i>&lt;/a>
                &lt;a href="#" title="&lt;?=__('Smazat')?>">&lt;i class="fas fa-trash">&lt;/i>&lt;/a>
              &lt;/div>
              &lt;p class="tree__leave__caption">Popis potomečka&lt;/p>
            &lt;/div>
          &lt;/li>
          &lt;li>
            &lt;div class="tree__leave">
              Potomeček
              &lt;span style="font-weight: normal; font-size: 10pt">(22)&lt;/span>
              &lt;div class="tree__leave__functions">
                &lt;a href="#" title="&lt;?=__('Vytvořit potomka')?>">&lt;i class="fas fa-plus">&lt;/i>&lt;/a>
                &lt;a href="#" title="&lt;?=__('Editovat')?>">&lt;i class="fas fa-edit">&lt;/i>&lt;/a>
                &lt;a href="#" title="&lt;?=__('Smazat')?>">&lt;i class="fas fa-trash">&lt;/i>&lt;/a>
              &lt;/div>
              &lt;p class="tree__leave__caption">Popis potomečka&lt;/p>
            &lt;/div>
          &lt;/li>
        &lt;/ul>
      &lt;/li>
    &lt;/ul>
  &lt;/li>
  &lt;li>
    &lt;div class="tree__leave">
      Hlavní úroveň - druhá položka&nbsp;
      &lt;span style="font-weight: normal; font-size: 10pt">(73)&lt;/span>
      &lt;div class="tree__leave__functions">
        &lt;a href="#" title="&lt;?=__('Vytvořit potomka')?>">&lt;i class="fas fa-plus">&lt;/i>&lt;/a>
        &lt;a href="#" title="&lt;?=__('Editovat')?>">&lt;i class="fas fa-edit">&lt;/i>&lt;/a>
        &lt;a href="#" title="&lt;?=__('Smazat')?>">&lt;i class="fas fa-trash">&lt;/i>&lt;/a>
      &lt;/div>
      &lt;p class="tree__leave__caption">Popis když chceme nějaké vysvětlení ...&lt;/p>
    &lt;/div>
  &lt;/li>
&lt;/ul>
</code>
</pre>
<ul class="tree full-width">
  <li>
    <div class="tree__leave">
      Hlavní úroveň 
      <span style="font-weight: normal; font-size: 10pt">(42)</span>
      <div class="tree__leave__functions">
        <a href="#" title="<?=__('Vytvořit potomka')?>"><i class="fas fa-plus"></i></a>
        <a href="#" title="<?=__('Editovat')?>"><i class="fas fa-edit"></i></a>
        <a href="#" title="<?=__('Smazat')?>"><i class="fas fa-trash"></i></a>
      </div>
      <p class="tree__leave__caption">Popis když chceme nějaké vysvětlení ...</p>
    </div>
    <ul class="tree full-width">
      <li>
        <div class="tree__leave">
          Potomek
          <span style="font-weight: normal; font-size: 10pt">(3)</span>
          <div class="tree__leave__functions">
            <a href="#" title="<?=__('Vytvořit potomka')?>"><i class="fas fa-plus"></i></a>
            <a href="#" title="<?=__('Editovat')?>"><i class="fas fa-edit"></i></a>
            <a href="#" title="<?=__('Smazat')?>"><i class="fas fa-trash"></i></a>
          </div>
          <p class="tree__leave__caption">Popis potomka</p>
        </div>
        <ul class="tree full-width">
          <li>
            <div class="tree__leave">
              Potomeček
              <span style="font-weight: normal; font-size: 10pt">(7)</span>
              <div class="tree__leave__functions">
                <a href="#" title="<?=__('Vytvořit potomka')?>"><i class="fas fa-plus"></i></a>
                <a href="#" title="<?=__('Editovat')?>"><i class="fas fa-edit"></i></a>
                <a href="#" title="<?=__('Smazat')?>"><i class="fas fa-trash"></i></a>
              </div>
              <p class="tree__leave__caption">Popis potomečka</p>
            </div>
          </li>
          <li>
            <div class="tree__leave">
              Potomeček
              <span style="font-weight: normal; font-size: 10pt">(22)</span>
              <div class="tree__leave__functions">
                <a href="#" title="<?=__('Vytvořit potomka')?>"><i class="fas fa-plus"></i></a>
                <a href="#" title="<?=__('Editovat')?>"><i class="fas fa-edit"></i></a>
                <a href="#" title="<?=__('Smazat')?>"><i class="fas fa-trash"></i></a>
              </div>
              <p class="tree__leave__caption">Popis potomečka</p>
            </div>
          </li>
        </ul>
      </li>
    </ul>
  </li>
  <li>
    <div class="tree__leave">
      Hlavní úroveň - druhá položka 
      <span style="font-weight: normal; font-size: 10pt">(73)</span>
      <div class="tree__leave__functions">
        <a href="#" title="<?=__('Vytvořit potomka')?>"><i class="fas fa-plus"></i></a>
        <a href="#" title="<?=__('Editovat')?>"><i class="fas fa-edit"></i></a>
        <a href="#" title="<?=__('Smazat')?>"><i class="fas fa-trash"></i></a>
      </div>
      <p class="tree__leave__caption">Popis když chceme nějaké vysvětlení ...</p>
    </div>
  </li>
</ul>

<div class="separator"></div>


<br>
<br>
<div style="display: inline-block; clear: both; border: 1px solid rgba(203, 196, 188, 0.2); padding: 0 1rem;">
<h2>Other Rules:</h2>
<strong>Form Item Caption</strong> má <strong>1.8rem</strong> height<br>
<strong>Form Item Field</strong> má <strong>3rem</strong> height<br>
<strong>Small Button</strong> má <strong>3.4rem</strong> height<br>
Všechny <strong>jednotky</strong> uvádějme v <strong>rem</strong> nebo <strong>em</strong> (Vol s rozumem dle potřeby.)<br>
<strong>Třídy na které jsou navázány javascript eventy</strong> začínají <strong>js-</strong> a bude zřetelně jasné co dělají. Pokud ne, mohou být kodérem smazány.<br>
<strong>Paginator</strong> patří mezi filtr a tabulku a za tabulku!<br>
Každý <strong>filtr</strong> má minimálně dvě tlačítka: "Filtrovat" a "Zrušit nastavení"<br>
Používáme výhradně <strong>dynamic table</strong><br>
Prvek má pouze jedno HTML, nesmí se stát, že jedna věc bude vypisována v různých situacích různým kódem - pokud je to skutečně potřeba, bude to na jednom místě a budou to řešit podmínky uvnitř kódu. HTML se neopakuje! (Viz Dropzony)<br>
</div>





<br>
<br>
<br>
<br>
<br>

<div style="color: red; border-bottom: 3px solid red; font-size: 2rem; text-align: center;">
  Cokoli za touto čarou je staré a neřiď se tím!
</div>

<section class="col-xs-12">
  <a class="header__fast-nav--add" href="<?= $editURL ?>"><?= __('Přidat') ?></a>
</section>


<section class="col-xs-12">
  <span class="header__filter-button"><span class="turn-off-word"><?=_('Vypni')?> </span><?=_('Filtr')?></span>
</section>

<section class="col-xs-12">
  <form id="list-filter" action="" method="get" class="form--filter ">
    <input type="hidden" name="setFilter" value="1">
    <div class="col-xs-12 col-sm-7 col-md-5">
      <label class="form__item--text">
        <span class="form__item__caption--text">Příjmení</span>
        <input type="text" class="form__item__field--text" value="" name="lastName"/>
      </label>        
    </div>
    <div class="col-xs-12 col-sm-4 col-md-4">
      <label class="form__item--checkbox">
        <input type="checkbox" class="form__item__field--checkbox" value="1" checked="checked" name="activeOnly"/>
        <span class="form__item__caption--checkbox">Pouze zapnuté</span>
      </label>        
    </div>
    <div class="col-xs-12 col-sm-12 col-md-3">
        <div class="form__item--buttons" style="margin-top: 3rem;">
            <button name="button" size="" class="btn--secondary defbutton">Nastav</button>
        </div>
    </div>
  </form>
</section>

<div class="col-xs-12">
  <pre>V tomto konkrétním fitru má tlačítko "Nastav" inline styl margin-top: 3rem;
Je to kvůli tomu, že při takovémto filtru vychází tlačítko na řádek s formulářovými prvky. Pokud by tlačítko bylo na samostatném řádku, inline styl odstraň. 
Při úpravě dej pozor a uprav velikostně nejen col-md hodnoty, ale také col-sm a col-xs
<div class="note--devel">A vůbec by filtrace měla být jinak</div></pre>
</div>

<section class="col-xs-12">
  <table>
    <thead>
      <tr>
        <th>#</th>
        <th><?= __("Název") ?></th>
        <th><?= __("Aktivní") ?></th>
        <th><?= __('Funkce') ?></th>
      </tr>
    </thead>
    <tbody id="table_sortable">
      <?php
      
      $b = array_fill(0, 10, new \IZON\Modules\StyleGuide\Domain\StyleGuide());
      foreach ($b as $key => $obj) {
        $obj->setId($key);
        $obj->setPosition($key);
        $obj->setName(md5(rand(0, 100)));
        /* @var $obj \IZON\AppModules\Banners\Domain\Banner */
        echo '<tr data-id="'.$obj->getId().'" data-postion="'.$obj->getPosition().'">
                  <td>' . $obj->getId() . '</td>
                  <td><a href="' . $editURL . '">' . $obj->getName() . '</a></td>' .
        '<td>' . AdminPHPView\getPropetryCodeToChange($thisModule, $obj, 'active') . '</td>' .
        '<td>' .
        '<a href="' . $editURL . '" class="fce--edit" title="' . __('Editovat') . '" ></a>' .
        '<a href="' . $deleteURL . '" class="fce--delete" title="' . __('Smazat') . '" rel="' . $obj->getName() . '"></a>' .
        '</td>' .
        '</tr>';
      }
      ?>
    </tbody>
  </table>
</section>

<div class="col-xs-12">
  <pre>Formuláře skládej tak, aby pole měla nějakou logickou posloupnost a snaž se je řadit do ucelených celků</pre>
</div>

<section id="sec-basic" class="col-xs-12">

<div class="row">
<?php
    $fields = $form->getFileds();

    echo \IZON\Admin\Forms\getAdminField($form, 'id');

    echo  '<div class="col-xs-12 col-sm-6 col-md-4">'.
            \IZON\Admin\Forms\getAdminField($form, 'charField').
          '</div>';
    echo  '<div class="col-xs-12 col-sm-6 col-md-4">'.
            \IZON\Admin\Forms\getAdminField($form, 'email').
          '</div>';
    echo  '<div class="col-xs-12 col-sm-6 col-md-4">'.
            \IZON\Admin\Forms\getAdminField($form, 'datefield').
          '</div>';
    echo  '<div class="col-xs-12 col-sm-6 col-md-6">'.
            \IZON\Admin\Forms\getAdminField($form, 'textField').
            '<div class="row">'.
              '<div class="col-xs-12 col-sm-6">'.
                \IZON\Admin\Forms\getAdminField($form, 'intfiled').
              '</div>'.
              '<div class="col-xs-12 col-sm-6">'.
                \IZON\Admin\Forms\getAdminField($form, 'floatfield').
              '</div>'.
            '</div>'.
          '</div>';
    echo  '<div class="col-xs-12 col-sm-6 col-md-6">'.
            '<div class="form__item--container" style="margin-top: 2.8rem;">'.
              \IZON\Admin\Forms\getAdminField($form, 'radiodfiled').
            '</div>'.
            '<pre>První container má opět nastaven inline styl s margin-top, kvůli zarovnání s textarea - aby to prostě vypadalo hezky :). Při běžném užití ale nastaven nebude.</pre>'.
            '<div class="form__item--container--gray">'.
              \IZON\Admin\Forms\getAdminField($form, 'radiodfiled').
            '</div>'.
            '<pre>Jsou dva typy containerů "form__item--container" a "form__item--container--gray"</pre>'.
            '<pre>Pokud chci něco odsadit na nový řádek, vložím před něj .clearfix a nemusím to balit do .row.</pre>'.
          '</div>';
    echo  '<div class="clearfix"></div>';
    echo  '<div class="col-xs-12 col-sm-6 col-md-4">'.
              \IZON\Admin\Forms\getAdminField($form, 'phonedfiled').          
          '</div>';
    echo  '<div class="clearfix"></div>';
    echo  '<div class="col-xs-12 col-sm-6 col-md-4">'.
              \IZON\Admin\Forms\getAdminField($form, 'selectbox').          
          '</div>';
    echo  '<div class="col-xs-12 col-sm-6 col-md-4">'.
              \IZON\Admin\Forms\getAdminField($form, 'passwdfiled').          
          '</div>';
    echo  '<div class="col-xs-12 col-sm-6 col-md-4">'.
              \IZON\Admin\Forms\getAdminField($form, 'checkbox').          
          '</div>';
   echo   '<div class="col-xs-12">'.
            '<pre>Checkboxy se snaž dávat na konec řádku, protože neznáme délku popisu a vypadá to tak lépe :)</pre>'.
          '<div>';
?>
</div>
<div class="row">
    <div class="col-xs-12 col-sm-6 col-md-4">
        <?= \IZON\Admin\Forms\getAdminField($form, 'checkboxListFiled') ?>
    </div>
</div>
    
</section>

<div class="col-xs-12">
  <pre>
<strong>Ikonky (i ty v menu)</strong>
Vyber na: <a href="http://fontawesome.io/icons/">http://fontawesome.io/icons/</a> a název ikony vlož do DB do sloupce pro ikony.
Obecně pak když dáš něčemu třídu např class="icon--plane", tak to bude mít tu danou ikonu.
např: &#60;a class="btn--secondary icon--plane" href="#">Přidat&#60;/a&#62;
<a class="btn--secondary icon--plane" href="<?= $editURL ?>"><?= __('Přidat') ?></a>
  </pre>
</div>

<div class="col-xs-12">
  <pre>
<strong>Buttonky</strong>
&#60;a class="btn--secondary icon--plane" href="#">Přidat&#60;/a&#62; <a class="btn--secondary icon--plane" href="<?= $editURL ?>"><?= __('Přidat') ?></a>
&#60;a class="btn--important icon--plus" href="#">Přidat&#60;/a&#62; <a class="btn--important icon--plus" href="<?= $editURL ?>"><?= __('Přidat') ?></a>
&#60;a class="btn--big icon--paper-plane" href="#">Přidat&#60;/a&#62; <a class="btn--big icon--paper-plane" href="<?= $editURL ?>"><?= __('Přidat') ?></a>
&#60;a class="btn--big secondary icon--snowflake-o" href="#">Přidat&#60;/a&#62; <a class="btn--big secondary icon--snowflake-o" href="<?= $editURL ?>"><?= __('Přidat') ?></a>


&#60;a class="btn--small icon--recycle" href="#">Přidat&#60;/a&#62; - pro použití uvnitř formulářů má nastavené <a class="btn--small icon--recycle" href="<?= $editURL ?>"><?= __('Přidat') ?></a>


&#60;a class="btn--small btn--green icon--motorcycle" href="#">Přidat&#60;/a&#62; <a class="btn--small btn--green icon--motorcycle" href="<?= $editURL ?>"><?= __('Přidat') ?></a>


&#60;a class="btn--small btn--red icon--music" href="#">Přidat&#60;/a&#62; <a class="btn--small btn--red icon--music" href="<?= $editURL ?>"><?= __('Přidat') ?></a>

<br>
&#60;a class="btn--back icon--chevron-left" href="#">Zpět&#60;/a&#62; - tento button má nastaven zarovnání doleva kvůli jeho použití vespod stránek<br><a class="btn--back icon--chevron-left" href="<?= $editURL ?>"><?= __('Zpět') ?></a>
  </pre>
</div>

<div class="col-xs-12 col-sm-12 col-md-6">
  

<div class="clearfix"></div>

<div class="col-xs-12 col-sm-6">
  <pre>
<strong>Ouška (Záložky)</strong>
<div class="note--devel">TODO</div></pre>
  </pre>
</div>

<div class="clearfix"></div>

<div class="col-xs-12">
              <pre>
<strong>Poznámka</strong>
> Je to span s třídou <i>form__item__note--sticky</i>
> Nebo div se třídou <i>form__item__note--info</i>
<xmp>
<span class="form__item__note--sticky">
    Poslední úprava: Markéta Štěpánková 09.11.2017 17:30
</span>
    
nebo
    
<div class="form__item__note--info">
    Zvolte alespoň jednu kategorii.
</div>
</xmp>
<span class="form__item__note--sticky">Poslední úprava: Markéta Štěpánková 09.11.2017 17:30</span>

<div class="form__item__note--info">Zvolte alespoň jednu kategorii.</div>
  </pre>
</div>

<div class="col-xs-12">
  <div class="form__item--buttons">
    <a href="#" class="btn--back icon--chevron-left">Zpět</a>
    <button type="submit" class="btn--big">Uložit</button>
  </div>
</div>

<div class="popup">
  <div class="popup__message confirmation-deleting">
    <div class="close"></div>
    <span><?= __('Opravdu chcete smazat záznam') ?> <strong class="zaznam"></strong>?</span>
    <a href="#" class="btn--secondary" id="back"><?= __('Vrátit') ?></a>
    <a href="#" class="btn--important" id="do"><?= __('Smazat') ?></a>
  </div>
</div>
