<?php

namespace IZON\Modules\StyleGuide\Admin\Controllers;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

use IZON\Modules\StyleGuide\Admin\Forms\AdminFormFactory;

use IZON\Modules\StyleGuide\Domain\StyleGuide;

/**
 */
class StyleGuideController implements Controller {

    /**
     * @var string
     */
    protected $viewName;


    function __construct($viewName) {
        $this->viewName = $viewName;
    }

    public function execute(HttpRequest $request) {
        
        $mav = new ModelAndView($this->viewName);
        
        $mav->putParameter('form', AdminFormFactory::createForm());
        
        $styleGuideObjects = array_fill(0, 10, new StyleGuide());
        foreach($styleGuideObjects as $key => $obj) {
            $obj->setId($key);
            $obj->setPosition($key);
            $obj->setName(md5(rand(0, 100)));
        }
        $mav->putParameter('styleGuideObject', $styleGuideObjects);
        
        return $mav;
    }

}
