<?php

namespace IZON\Styleguide\Admin\Forms;

use IZON\Forms\Form;

use IZON\Users\Forms\UserFormFactory;

/**
 * factory pro vytvareni formularu
 */
class AdminFormFactory {
    
    public static function createForm() {
        $form = new Form();
        $form->addIdField('id', _('Id'));
        $form->addCharField('charField', _('input text'));
        $form->addTextField('textField', _('textarea'));
        $form->addEmailField('email', _('email'));
        $form->addCheckboxField('checkbox', _('checkbox'));
        $form->addDateFiled('datefield', _('input date'));
        $form->addFileField('filefield', _('input file'));
        $form->addFloatField('floatfield', _('input float'));
        $form->addHiddenField('hidden', _('input hidden'));
        $form->addImageField('image', _('input image'));
        $form->addIntegerField('intfiled', _('input integer'));
        $form->addPasswordField('passwdfiled', _('input passwd'));
        $form->addPhoneField('phonedfiled', _('input phone'));
        $form->addRadioListField('radiodfiled', _('input radio'))->setOptions(['a' => 'prvni', 'b' => 'druhy']);
        $form->addCheckboxListField('checkboxListFiled', _('input CheckboxList'))->setOptions(['a' => 'prvni', 'b' => 'druhy'], function($emement, $index) { return ["key" => $index, "label" => $emement]; });
        $form->addSelectField('selectbox', _('selectbox'))->setOptions(['a' => 'prvni', 'b' => 'druhy']);
        
        return $form;
    }
}
