<?php

use IZON\DB\Paginator\PaginatorConfig;

// soucasny modul
$thisModule = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
/* @var $paginatorConfig PaginatorConfig */
$paginatorConfig = PHPView\getParameter("paginatorConfig");
/* @var $pageContent IZON\DB\Paginator\PageContent */
$pageContent = \PHPView\getParameter("pageContent");
?>

<div class="col-xs-12">
    <h1><?= __('Výpis modulů') ?></h1>
</div>

<?php
$installFormURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "installForm", [], $thisModule->getIdentifier());


$totalCount = $pageContent->getTotalCount();
$maxPageSize = $paginatorConfig->getPageSize();
$firstResult = $paginatorConfig->getFirstResult();

$pagesCout = ceil($totalCount / $maxPageSize);
$currentPage = $firstResult / $maxPageSize + 1;


$filterActive = "";
if(PHPView\getParameter("filterActive")) {
    $filterActive = " active";
}
$filterForm = PHPView\getParameter("filterForm");
?>

<div class="col-xs-12" style="padding-top: 10px; padding-bottom: 10px;">
    <a class="btn btn--small btn--mint" href="<?= $installFormURL ?>"><i class="fas fa-plus"></i><?= __('Přidat') ?></a>
</div>

<section class="col-xs-12">
    <div class="table-icons" style="display: none;">
        <i class="fas fa-check" data-fa-symbol="icon--true"></i>
        <i class="fas fa-times" data-fa-symbol="icon--false"></i>
        <i class="fas fa-edit" data-fa-symbol="icon--edit"></i>
        <i class="fas fa-trash-alt" data-fa-symbol="icon--delete"></i>
    </div>
    <table class="table--dynamic">
        <thead>
            <tr>
                <?php
                writeListHeaderField($paginatorConfig, "id", __("#"));
                writeListHeaderField($paginatorConfig, "type", __("Typ"));
                writeListHeaderField($paginatorConfig, "identifier", __("Identifikátor"));
                writeListHeaderField($paginatorConfig, "name", __("Jméno"));
                writeListHeaderField($paginatorConfig, "moduleOrder", __("Pořadí"));
                writeListHeaderField($paginatorConfig, "enabled", __("Zapnutý"));
                writeListHeaderField($paginatorConfig, "adminVisible", __("Zobrazit v adminu"));
                ?>
                <th style="">Funkce</th>
            </tr>
        </thead>
        <tbody id="list-table">
            <?php
            foreach($pageContent->getPage() as $obj) {
                /* @var $obj IZON\Admin\Domain\AdminModule */
                $editURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "edit", ["id" => $obj->getId()], $thisModule->getIdentifier());
                $deleteURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "delete", ["id" => $obj->getId()], $thisModule->getIdentifier());
                ?>
                <tr>
                    <td> <?= $obj->getId() ?> </td>
                    <td><?= $obj->getType() ?></td>
                    <td>
                        <a href="<?= $editURL ?>"><?= $obj->getIdentifier() ?></a>
                    </td>
                    <td>
                        <a href="<?= $editURL ?>"><?= $obj->getName() ?></a>
                    </td>
                    <td><?= $obj->getModuleOrder() ?></td>
                    <td>
                        <?= AdminPHPView\getPropetryCodeToChange($thisModule, $obj, 'active') ?>
                    </td>
                    <td>
                        <?= AdminPHPView\getPropetryCodeToChange($thisModule, $obj, 'adminVisible') ?>
                    </td>
                    <td>
                        <a href="<?= $editURL ?>"><svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--edit"></use></svg></a>
                        <a href="<?= $deleteURL ?>" rel="<?= $obj->getId() . ' ' . $obj->getIdentifier() . " - " . $obj->getName() ?>"><svg class="svg-inline--fa fa-w-20"><use xlink:href="#icon--delete"></use></svg></a>
                    </td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>

</section>

<!-- POPUP - Confirmation of deleting item -->
<div class="popup">
    <div class="popup__message confirmation-deleting">
        <div class="close"></div>
        <span><?= __('Opravdu chcete smazat záznam') ?> <strong class="zaznam"></strong>?</span>
        <a href="#" class="btn--secondary" id="back"><?= __('Vrátit') ?></a>
        <a href="#" class="btn--important" id="do"><?= __('Smazat') ?></a>
    </div>
</div>
<?php

function writeListHeaderField(PaginatorConfig $paginatorConfig, $propertyName, $feldName, $width = NULL) {
    $isSortable = $paginatorConfig->isOrder($propertyName);
    $order = $paginatorConfig->getOrders()[0];

    $classes = [];
    // je raditelny sloupe
    if($isSortable) {
        $classes[] = 'sortable';
        if($order->getName() == $propertyName) {
            if($order->getType() == \IZON\DB\QueryParams\OrderBy::ORDER_ASC) {
                $classes[] = "sorted--down";
            } else {
                $classes[] = "sorted--up";
            }
        }
    }
    // sirka sloupecku
    $widthStyle = "";
    if($width != NULL) { // je nastavena nejaka sirka
        if(IZON\String\endsWith($width, "%") // konci procentem
                || IZON\String\endsWith($width, "px")) { // konci pixely
            $widthStyle = "width: " . $width;
        } else {
            throw new Exception("Nepodporovany fomat sirky sloupce. Podporovany jsou % a px");
        }
    }

    echo '<th ' . (!IZON\Arrays\isEmpty($classes) ? 'class="' . implode(" ", $classes) . '"' : '')
    . ' data-property-name="' . $propertyName
    . '" data-order="' . ($order->getType() == \IZON\DB\QueryParams\OrderBy::ORDER_ASC ? 'down' : 'up')
    . '" style="' . $widthStyle . '" >
        ' . $feldName;
    echo '<span class="sortable__down"></span>';
    echo '<span class="sortable__up"></span>';
    echo '</th>';
}
