<?php

namespace IZON\Modules\AdminModules\Admin\Forms;

use IZON\Forms\Form;

/**
 * factory pro vytvareni formularu pro uzivatel
 */
class AdminModuleFormFactory
{
    public static function createModuleForm()
    {
        $form = new Form();

        $form->addIdField("id", _("Id"));
        $form->addCharField("type", _("Typ"))->addProperty("readonly")->setRequired();
        $form->addCharField("identifier", _("Identifikátor"))->setRequired();
        $form->addCharField("name", _("Jméno"))->setRequired();
        $form->addCheckboxField("active", _("Zapnutý"));
        $form->addCheckboxField("adminVisible", _("Zobrazit v adminu"));
        $form->addCheckboxField("superuserOnly", _("SuperuserOnly"));
        $form->addIntegerField("moduleOrder", _("Pořadí"))->setRequired();
        
        $form->addCharField("icon", _("Ikona"));
        
        return $form;
    }
    
    public static function createRoleModuleForm($preffix, $tagName)
    {
        $form = new Form($preffix);
        $form->addCheckboxField("hasRole", $tagName)->setUseLabel(false);
        
        return $form;
    }
    
    public static function createModuleSettingForm($preffix)
    {
        $form = new Form($preffix);
        $form->addIdField("id", _("Id"));
        $form->addCharField("name", _("Název"))->setReadonly(true);
        $form->addCharField("value", _("Hodnota"));
        
        return $form;
    }
    
    public static function createModuleInstallForm(array $modulesTypes)
    {
        $form = new Form();

        $moduleTypeOptions = [];
        foreach ($modulesTypes as $modulesTypeIdentifier => $modulesTypeName) {
            $moduleTypeOptions[] = ['key' => $modulesTypeIdentifier, 'label' => $modulesTypeName];
        }
        $form->addSelectField("type", _("Typ"))
            ->setOptions($moduleTypeOptions)->setRequired();

        $form->addCharField("identifier", _("Identifikátor"))->setRequired();
        $form->addCharField("name", _("Jméno"))->setRequired();
        $form->addIntegerField("moduleOrder", _("Pořadí"))->setRequired();
        
        return $form;
    }
}
