<?php

namespace IZON\AdminModules\Config;

use IZON\Admin\Config;
use IZON\DB\TransactionManagementFactory;
use IZON\Modules\AdminModules\Admin\Controllers\ModuleController;
use IZON\Modules\AdminModules\Admin\Services\ModuleService;
use function IZON\Admin\DI\moduleGet;
use function IZON\Admin\DI\moduleIdentifier;
use function IZON\DI\factory;
use function IZON\DI\get;
use function IZON\DI\object;

return [
    'moduleActions' => [
        // jaka akce se ma provest defaultne pri kliknuti na nazev modulu
        'defaultAction' => 'execute',
        // jake akce modul obsahuje a jak se maji pojmenovat
        'actions' => [
            'execute' => [
                'name' => "Moduly",
                'controllerId' => 'admin.moduleController',
                'action' => 'execute',
            ],
        ],
        // jake akce se maji zobrazit v menu
        'menuActions' => []

    ],

    'admin.moduleServiceBare' => object(ModuleService::class)
        ->constructor(
            get(Config::APP_DIR_IDENTIFIER),
            get(Config::CONFIG_DIR_IDENTIFIER),
            get(Config::DEFAULT_DB_ENTITY_MANAGER_IDENTIFIER)
        ),
    'admin.moduleServiceTMF' => object(TransactionManagementFactory::class)
        ->constructor(
            get(Config::DEFAULT_DB_CONNECTION_IDENTIFIER),
            moduleGet('admin.moduleServiceBare')
        ),
    'admin.moduleService' => factory([moduleIdentifier('admin.moduleServiceTMF'), 'create']),
    'admin.moduleController' => object(ModuleController::class)
        ->constructor(
            moduleGet('admin.moduleService'),
            "izon/admin-modules-module/modules"
        ),
];
