<?php
use function IZON\Admin\Forms\getAdminField;

$thisModule = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
$form       = \PHPView\getParameter("form");

$saveURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(),
                                            "save",
                                            [],
                                            $thisModule->getIdentifier());

if( $form->getField("id")->getValue() == NULL ) {
    $pageTitle = __("Nový uživatel");
} else {
    $objectName = trim($form->getField("name")->getValue());
    $pageTitle  = '<light>'.__('Editace modulu').':</light> '.trim($objectName);
}

echo '<div class="col-xs-12">'.
      '<h1>'.$pageTitle.'</h1>'.
     '</div>'.LF;

?>

<form class="container" action="<?= $saveURL ?>" method="post" enctype="multipart/form-data" role="form">
<div>
<?php
    echo getAdminField($form, "id");
    
    echo getAdminField($form, "type");
    echo getAdminField($form, "identifier");
    echo getAdminField($form, "name");
    
    echo getAdminField($form, "active");
    echo getAdminField($form, "adminVisible");
    echo getAdminField($form, "superuserOnly");
    echo getAdminField($form, "moduleOrder");
    
//    echo getAdminField($form, "fkCountryId");
//    echo getAdminField($form, "fkLanguageId");
    echo getAdminField($form, "icon");
?>
    
    <h2>Role</h2>
<?php
$roleForms = PHPView\getParameter('roleForms');
foreach($roleForms as $roleForm) {
    echo getAdminField($roleForm, "hasRole");
}
?>

<h2>Nastavení</h2>
<?php
$settingForms = PHPView\getParameter('settingForms');
foreach($settingForms as $settingForm) {
    echo getAdminField($settingForm, "id");
    echo $settingForm->getField("name")->getValue() .': ';
    echo getAdminField($settingForm, "value") .'<br>';
}
?>
</div> <!-- Konec knihy col -->
        


    <div class="col-xs-12">
        <div class="form__item--buttons">
            <?php
                $backURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(), "execute", [], $thisModule->getIdentifier());
          echo '<a href="'.$backURL.'" class="btn btn--gray" style="float: left;"><i class="fas fa-angle-left"></i>'.__('Zpět').'</a>'.
                '<button type="submit" class="btn btn--mint btn--big"><i class="fas fa-check"></i>'.__('Uložit').'</button>';
           ?>
        </div>
    </div>
    
</form> <!-- uzavira hlavni form -->