<?php

namespace IZON\Modules\AdminModules\Config;

use IZON\Admin\Config;
use IZON\DB\TransactionManagementFactoryObject;
use IZON\DI\DI;
use IZON\Modules\AdminModules\Admin\Controllers\ModuleController;
use IZON\Modules\AdminModules\Admin\Services\ModuleService;


return [
    'moduleActions' => [
        // jaka akce se ma provest defaultne pri kliknuti na nazev modulu
        'defaultAction' => 'execute',
        // jake akce modul obsahuje a jak se maji pojmenovat
        'actions' => [
            'execute' => [
                'name' => "Moduly",
                'controllerId' => 'admin.moduleController',
                'action' => 'execute',
            ],
        ],
        // jake akce se maji zobrazit v menu
        'menuActions' => []

    ],

    'admin.moduleServiceBare' => DI::autowire(ModuleService::class)
        ->constructor(
            DI::get(Config::APP_DIR_IDENTIFIER),
            DI::get(Config::CONFIG_DIR_IDENTIFIER)
        ),
    'admin.moduleService' => DI::factoryObject(TransactionManagementFactoryObject::class)
        ->constructor(
            DI::get(Config::DEFAULT_DB_CONNECTION_IDENTIFIER),
            Config::moduleGet('admin.moduleServiceBare')
        ),
    'admin.moduleController' => DI::autowire(ModuleController::class)
        ->constructor(
            Config::moduleGet('admin.moduleService'),
            "izon/admin-modules-module/modules"
        ),
];
