<?php

// includuje funkce pro konfiguraci DI
use function IZON\DI\get;
use function IZON\DI\object;
use function IZON\DI\factory;
// includuje funkce pro konfiguraci DI
use function IZON\Admin\DI\moduleGet;

use IZON\Admin\Config;

use IZON\DB\TransactionManagementFactoryBean;

use IZON\Modules\AdminModules\Admin\Services\ModuleService;
use IZON\Modules\AdminModules\Admin\Controllers\ModuleController;

$dbConnIdentifier = Config::DEFAULT_DB_CONNECTION_IDENTIFIER;


return [
    'moduleActions' => [
        // jaka akce se ma provest defaultne pri kliknuti na nazev modulu
        'defaultAction' => 'execute', 
        // jake akce modul obsahuje a jak se maji pojmenovat
        'actions' => [
            'execute' => [
                'name' => "Moduly", 
                'controllerId' => 'admin.moduleController',
                'action' => 'execute',
            ],
        ],
        // jake akce se maji zobrazit v menu
        'menuActions' => []
        
    ],
    
    'admin.moduleServiceBare' => object(ModuleService::class)
                                            ->constructor(get(Config::APP_DIR_IDENTIFIER), 
                                                    get(Config::CONFIG_DIR_IDENTIFIER)),
    'admin.moduleService' => object(TransactionManagementFactoryBean::class)
                                                ->constructor(get($dbConnIdentifier), 
                                                        moduleGet('admin.moduleServiceBare')
                                                    ),
    'admin.moduleController' => object(ModuleController::class)
                                                        ->constructor( moduleGet('admin.moduleService'),
                                                              "izon/admin-modules-module/modules" ),
];
