<?php
// soucasny modul
$thisModule = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
$listContentURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(),
                                                        "ajaxListContent",
                                                        [],
                                                        $thisModule->getIdentifier());
$changeListOrderURL = AdminPHPView\getModuleActionURL($thisModule->getControllerId(),
                                                        "ajaxChangeListOrder",
                                                        [],
                                                        $thisModule->getIdentifier());

?>
<script type="text/javascript">
var listContentURL = "<?= $listContentURL ?>";
var changeListOrderURL = "<?= $changeListOrderURL ?>";

var filterFormIdentifier = "#list-filter";
var listTableIdentifier = "#list-table";
var clearFilterFormIdentifier = ".turn-off-word";

$(document).ready(function() {
    var filterFields = $(filterFormIdentifier +" input, "+ filterFormIdentifier +" select");
    filterFields.change(function() {
        ajaxGetListContent(renderPage);
    });
    filterFields.keyup(function() {
        ajaxGetListContent(renderPage);
    });
    filterFields.keydown(function(event){
        if(event.keyCode == 13) { // neodesilej formular na enter
            event.preventDefault();
            return false;
        }
    });
    
    // vycisteni filtru
    $(clearFilterFormIdentifier).click(function() {
        ajaxClearFilter(renderPage);
    });
    
    // zmena razeni
    $('.sortable').click(function(event) {
       var propertyName = $(this).attr('data-property-name');
       ajaxChangeListOrder(propertyName, renderPage);
    });
    
    // zmeni stranky
    $('.page-switcher__prev').click(function(event) {
        var currentPage = getCurrentPage();
        var min = 1;
        if( min < currentPage ) {
            var newPage = currentPage-1;
            setCurrentPage(newPage);
            ajaxChangePage(newPage, renderPage);
        }
    });
    $('.page-switcher__next').click(function(event) {
        var currentPage = getCurrentPage();
        var max = getMaxPage();
        if( currentPage < max ) {
            var newPage = currentPage+1;
            setCurrentPage(newPage);
            ajaxChangePage(newPage, renderPage);
        }
    });
    $('.page-switcher [name="page"]').change(function(event) {
        var newPage = $(this).val();
        ajaxChangePage(newPage, renderPage);
    });
});

// vyrenderuje stranku tabulky
function renderPage(pageItems) {
    var html = ""; 
    $.each(pageItems, function(index, product) {
        html += '<tr>'+
            '<td>'+ product.id +'</td>'+
            '<td>'+ (product.code == null ? '' : product.code) +'</td>'+
            '<td>'+ (product.isbn == null ? '' : product.isbn) +'</td>'+
            '<td><a href="'+ product.editURL +'">'+ product.name +'</a></td>'+
            '<td>'+ product.authorName +'</td>'+
            '<td>'+ (product.active ? '<div class="true"></div>' : '<div class="false"></div>') +
            '</td>'+
            '<td>'+
                '<a href="'+ product.editURL +'" class="fce--edit"></a>'+
                '<a href="'+ product.deleteURL +'" class="fce--delete" rel="'+ product.name +'"></a>'+
            '</td>'+
        '</tr>';
    });
    return html;
}
</script>
