<?php

namespace IZON\AdminModules\Admin\Forms;

use IZON\Forms\Form;

/**
 * factory pro vytvareni formularu pro uzivatel
 */
class AdminModuleFormFactory {

    public static function createModuleForm() {
//        $countriesOptions = [];
//        foreach($activeCountries as $activeCountry) {
//            $countriesOptions[$activeCountry->getId()] = $activeCountry->getName();
//        }
//        
//        $langagesOptions = [];
//        foreach($activeLanguages as $activeLanguage) {
//            $langagesOptions[$activeLanguage->getId()] = $activeLanguage->getName();
//        }
//        
//        $localesOptions = [];
//        foreach($activeLocales as $activeLocale) {
//            $localesOptions[$activeLocale->getId()] = $activeLocale->getLocaleTag();
//        }
        
        $form = new Form();
        $form->addIdField("id", _("Id"));
        $form->addCharField("type", _("Typ"))->setReadonly(true)->setRequired();
        $form->addCharField("identifier", _("Identifikátor"))->setRequired();
        $form->addCharField("name", _("Jméno"))->setRequired();
        $form->addCheckboxField("enabled", _("Zapnutý"));
        $form->addCheckboxField("adminVisible", _("Zobrazit v adminu"));
        $form->addIntegerField("moduleOrder", _("Pořadí"))->setRequired();
        
//        $form->addSelectField("fkCountryId", __("Země"))->setOptions($countriesOptions);
//        $form->addSelectField("fkLanguageId", __("Jazyk"))->setOptions($langagesOptions);
//        $form->addSelectField("fkInterfaceLocaleId", __("Locale rozhraní"))->setOptions($localesOptions);
        
        $form->addCharField("icon", _("Ikona"));
        
        return $form;
    }
    
    public static function createRoleModuleForm($preffix, $tagName) {
        $form = new Form($preffix);
        $form->addCheckboxField("hasRole", $tagName)->setUseLabel(false);
        
        return $form;
    }
    
    public static function createModuleSettingForm($preffix) {
        $form = new Form($preffix);
        $form->addIdField("id", _("Id"));
        $form->addCharField("name", _("Název"))->setReadonly(true);
        $form->addCharField("value", _("Hodnota"));
        
        return $form;
    }
    
    public static function createModuleInstallForm(array $modulesTypes) {
        $form = new Form();
        
        $form->addSelectField("type", _("Typ"))->setOptions($modulesTypes)->setRequired();
        $form->addCharField("identifier", _("Identifikátor"))->setRequired();
        $form->addCharField("name", _("Jméno"))->setRequired();
        $form->addIntegerField("moduleOrder", _("Pořadí"))->setRequired();
        
        return $form;
    }
}
